/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.recalibration.covariates;

import htsjdk.samtools.SAMFileHeader;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.hellbender.utils.recalibration.covariates.ContextCovariate;
import org.broadinstitute.hellbender.utils.recalibration.covariates.Covariate;
import org.broadinstitute.hellbender.utils.recalibration.covariates.CycleCovariate;
import org.broadinstitute.hellbender.utils.recalibration.covariates.QualityScoreCovariate;
import org.broadinstitute.hellbender.utils.recalibration.covariates.ReadCovariates;
import org.broadinstitute.hellbender.utils.recalibration.covariates.ReadGroupCovariate;

public final class StandardCovariateList
implements Iterable<Covariate>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ReadGroupCovariate readGroupCovariate;
    private final QualityScoreCovariate qualityScoreCovariate;
    private final List<Covariate> additionalCovariates;
    private final List<Covariate> allCovariates;
    private final Map<Class<? extends Covariate>, Integer> indexByClass;

    public StandardCovariateList(RecalibrationArgumentCollection rac, List<String> allReadGroups) {
        this.readGroupCovariate = new ReadGroupCovariate(rac, allReadGroups);
        this.qualityScoreCovariate = new QualityScoreCovariate(rac);
        ContextCovariate contextCovariate = new ContextCovariate(rac);
        CycleCovariate cycleCovariate = new CycleCovariate(rac);
        this.additionalCovariates = Collections.unmodifiableList(Arrays.asList(contextCovariate, cycleCovariate));
        this.allCovariates = Collections.unmodifiableList(Arrays.asList(this.readGroupCovariate, this.qualityScoreCovariate, contextCovariate, cycleCovariate));
        this.indexByClass = new LinkedHashMap<Class<? extends Covariate>, Integer>();
        for (int i = 0; i < this.allCovariates.size(); ++i) {
            this.indexByClass.put(this.allCovariates.get(i).getClass(), i);
        }
    }

    public StandardCovariateList(RecalibrationArgumentCollection rac, SAMFileHeader header) {
        this(rac, ReadGroupCovariate.getReadGroupIDs(header));
    }

    public int numberOfSpecialCovariates() {
        return 2;
    }

    public List<String> getStandardCovariateClassNames() {
        return Collections.unmodifiableList(this.allCovariates.stream().map(cov -> cov.getClass().getSimpleName()).collect(Collectors.toList()));
    }

    public int size() {
        return this.allCovariates.size();
    }

    @Override
    public Iterator<Covariate> iterator() {
        return this.allCovariates.iterator();
    }

    public ReadGroupCovariate getReadGroupCovariate() {
        return this.readGroupCovariate;
    }

    public QualityScoreCovariate getQualityScoreCovariate() {
        return this.qualityScoreCovariate;
    }

    public Iterable<Covariate> getAdditionalCovariates() {
        return this.additionalCovariates;
    }

    public String covariateNames() {
        return String.join((CharSequence)",", this.getStandardCovariateClassNames());
    }

    public Covariate get(int covIndex) {
        return this.allCovariates.get(covIndex);
    }

    public int indexByClass(Class<? extends Covariate> clazz) {
        return this.indexByClass.getOrDefault(clazz, -1);
    }

    public void recordAllValuesInStorage(GATKRead read, SAMFileHeader header, ReadCovariates resultsStorage, boolean recordIndelValues) {
        int n = this.allCovariates.size();
        for (int i = 0; i < n; ++i) {
            Covariate cov = this.allCovariates.get(i);
            resultsStorage.setCovariateIndex(i);
            cov.recordValues(read, header, resultsStorage, recordIndelValues);
        }
    }

    public Covariate getCovariateByParsedName(String covName) {
        return this.allCovariates.stream().filter(cov -> cov.parseNameForReport().equals(covName)).findFirst().orElse(null);
    }
}

