/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.reference;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import org.broadinstitute.hellbender.utils.SimpleInterval;

public final class AbsoluteCoordinates {
    private final int[] lengths;
    private final int[] percentiles;
    private final long[] accumulative;
    private final long total;
    private final float percentileFactor;
    private final ToIntFunction<String> contigToIndex;
    private final IntFunction<String> indexToContig;
    private int lastCtg;

    private AbsoluteCoordinates(int[] lengths, long[] accumulative, ToIntFunction<String> contigToIndex, IntFunction<String> indexToContig) {
        this.lengths = lengths;
        this.accumulative = accumulative;
        this.contigToIndex = contigToIndex;
        this.indexToContig = indexToContig;
        this.total = accumulative[accumulative.length - 1];
        this.percentiles = AbsoluteCoordinates.calculatePercentiles(lengths, accumulative, this.total);
        this.percentileFactor = (float)(this.percentiles.length - 1) / (float)this.total;
        this.lastCtg = 0;
    }

    private static int[] calculatePercentiles(int[] lengths, long[] accumulative, long total) {
        int[] result = new int[(accumulative.length << 1) + 1];
        float fraction = (float)total / (float)(result.length - 1);
        double fractionAccumulator = 0.0;
        int j = 0;
        for (int i = 0; i < lengths.length; ++i) {
            long accumulativePlusLength = accumulative[i + 1];
            while (fractionAccumulator < (double)accumulativePlusLength && j < result.length - 1) {
                result[j++] = i;
                fractionAccumulator += (double)fraction;
            }
        }
        result[result.length - 1] = lengths.length - 1;
        return result;
    }

    public static AbsoluteCoordinates of(SAMSequenceDictionary dictionary) {
        ToIntFunction<String> contigToIndex = arg_0 -> ((SAMSequenceDictionary)dictionary).getSequenceIndex(arg_0);
        IntFunction<String> indexToContig = i -> dictionary.getSequence(i).getContig();
        List sequences = dictionary.getSequences();
        int numberOfSequences = sequences.size();
        int[] lengths = new int[numberOfSequences];
        long[] accumulative = new long[numberOfSequences + 1];
        for (int i2 = 0; i2 < numberOfSequences; ++i2) {
            SAMSequenceRecord sequence = (SAMSequenceRecord)sequences.get(i2);
            lengths[i2] = sequence.getSequenceLength();
        }
        long leftSum = lengths[0];
        for (int i3 = 1; i3 < numberOfSequences; ++i3) {
            accumulative[i3] = leftSum;
            leftSum += (long)lengths[i3];
        }
        accumulative[numberOfSequences] = leftSum;
        return new AbsoluteCoordinates(lengths, accumulative, contigToIndex, indexToContig);
    }

    public long toAbsolute(String ctgName, int position) {
        return this.toAbsolute(this.contigToIndex.applyAsInt(ctgName), position);
    }

    public long toAbsolute(SimpleInterval simpleInterval) {
        return this.toAbsolute(simpleInterval.getContig(), simpleInterval.getStart());
    }

    public long toAbsolute(int ctgIdx, int position) {
        if (this.lengths[ctgIdx] < position) {
            throw new IllegalArgumentException("position outside containg contig");
        }
        this.lastCtg = ctgIdx;
        return this.accumulative[ctgIdx] + (long)position;
    }

    public SimpleInterval toSimpleInterval(long absoluteStart, int length) {
        return this.toRelative(absoluteStart, (n, i, p) -> new SimpleInterval(n, p, p + length - 1));
    }

    public Relative toRelative(long absolute) {
        return this.toRelative(absolute, Relative::new);
    }

    public <E> E toRelative(long absolute, RelativeFactory<E> factory) {
        if (absolute < 1L) {
            throw new IllegalArgumentException("absolute cannot be less than 1");
        }
        if (absolute > this.total) {
            throw new IllegalArgumentException("absolute is too large");
        }
        if (this.accumulative[this.lastCtg] < absolute) {
            if (absolute <= this.accumulative[this.lastCtg + 1]) {
                return factory.create(this.indexToContig.apply(this.lastCtg), this.lastCtg, (int)(absolute - this.accumulative[this.lastCtg]));
            }
            return this.searchRelative(absolute, factory);
        }
        return this.searchRelative(absolute, factory);
    }

    private <E> E searchRelative(long target, RelativeFactory<E> factory) {
        int percentileIndex = (int)((float)target * this.percentileFactor);
        if (percentileIndex >= this.percentiles.length) {
            throw new IllegalArgumentException("xx " + target + " " + this.total);
        }
        int percentileCtg = this.percentiles[percentileIndex];
        if (percentileIndex < this.percentiles.length - 1) {
            return this.searchRelative(target, percentileCtg, this.percentiles[percentileIndex + 1], factory);
        }
        return this.searchRelative(target, percentileCtg, this.lengths.length - 1, factory);
    }

    private <E> E searchRelative(long target, int minCtgIdx, int maxCtgIdx, RelativeFactory<E> factory) {
        int i = minCtgIdx;
        int j = maxCtgIdx;
        while (i < j) {
            int mid = i + j >> 1;
            if (this.accumulative[mid] >= target) {
                j = mid - 1;
                continue;
            }
            if (this.accumulative[mid + 1] < target) {
                i = mid + 1;
                continue;
            }
            i = mid;
            break;
        }
        this.lastCtg = i;
        return factory.create(this.indexToContig.apply(i), i, (int)(target - this.accumulative[i]));
    }

    @FunctionalInterface
    static interface RelativeFactory<E> {
        public E create(String var1, int var2, int var3);
    }

    public static class Relative {
        public final String contig;
        public final int contigIndex;
        public final int position;

        Relative(String contig, int contigIndex, int position) {
            this.contig = contig;
            this.contigIndex = contigIndex;
            this.position = position;
        }
    }
}

