/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.reference;

import java.io.Serializable;
import java.util.Arrays;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;

public final class ReferenceBases
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] bases;
    private final SimpleInterval interval;

    public ReferenceBases(byte[] bases, SimpleInterval interval) {
        Utils.nonNull(bases);
        Utils.nonNull(interval);
        if (interval.size() != bases.length) {
            throw new IllegalArgumentException("interval must have same length as bases, " + interval + " " + interval.size() + "," + bases.length);
        }
        this.bases = bases;
        this.interval = interval;
    }

    public String toString() {
        return "ReferenceBases{bases=" + Arrays.toString(this.bases) + ", interval=" + this.interval + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferenceBases that = (ReferenceBases)o;
        if (!Arrays.equals(this.getBases(), that.getBases())) {
            return false;
        }
        return this.getInterval().equals(that.getInterval());
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.getBases());
        result = 31 * result + this.getInterval().hashCode();
        return result;
    }

    public byte[] getBases() {
        return this.bases;
    }

    public SimpleInterval getInterval() {
        return this.interval;
    }

    public ReferenceBases getSubset(SimpleInterval subsetInterval) {
        if (!this.interval.contains(subsetInterval)) {
            throw new GATKException("Reference doesn't match input interval (asked for " + subsetInterval.toString() + " but we have " + this.interval + ")");
        }
        int start = subsetInterval.getStart() - this.interval.getStart();
        int end = subsetInterval.getEnd() - this.interval.getStart();
        return new ReferenceBases(Arrays.copyOfRange(this.bases, start, end + 1), subsetInterval);
    }
}

