/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.reference;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.LineReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.fasta.CachingIndexedFastaSequenceFile;

public final class ReferenceUtils {
    private ReferenceUtils() {
    }

    public static String getFastaIndexFileName(String fastaFilename) {
        return fastaFilename + ".fai";
    }

    public static String getFastaDictionaryFileName(String fastaFilename) {
        int lastDot = fastaFilename.lastIndexOf(46);
        return fastaFilename.substring(0, lastDot) + ".dict";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SAMSequenceDictionary loadFastaDictionary(GATKPath fastaDictionaryFile) {
        try (InputStream fastaDictionaryStream = fastaDictionaryFile.getInputStream();){
            SAMSequenceDictionary sAMSequenceDictionary = ReferenceUtils.loadFastaDictionary(fastaDictionaryStream);
            return sAMSequenceDictionary;
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile("Error loading fasta dictionary file " + fastaDictionaryFile, (Exception)e);
        }
        catch (UserException.MalformedFile e) {
            throw new UserException.MalformedFile("Could not read sequence dictionary from given fasta file " + fastaDictionaryFile);
        }
    }

    public static SAMSequenceDictionary loadFastaDictionary(File fastaDictionaryFile) {
        return ReferenceUtils.loadFastaDictionary(new GATKPath(fastaDictionaryFile.getAbsolutePath()));
    }

    public static SAMSequenceDictionary loadFastaDictionary(InputStream fastaDictionaryStream) {
        SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
        BufferedLineReader reader = new BufferedLineReader(fastaDictionaryStream);
        SAMFileHeader header = codec.decode((LineReader)reader, fastaDictionaryStream.toString());
        if (header.getSequenceDictionary() == null || header.getSequenceDictionary().isEmpty()) {
            throw new UserException.MalformedFile("Could not read sequence dictionary from given fasta stream " + fastaDictionaryStream);
        }
        return header.getSequenceDictionary();
    }

    public static CachingIndexedFastaSequenceFile createReferenceReader(GATKPath referenceInput) {
        return new CachingIndexedFastaSequenceFile(referenceInput.toPath());
    }

    public static byte[] getRefBaseAtPosition(ReferenceSequenceFile reference, String contig, int start) {
        return reference.getSubsequenceAt(contig, (long)start, (long)start).getBases();
    }
}

