/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.gcs.BucketUtils;
import org.broadinstitute.hellbender.utils.report.GATKReportTable;
import org.broadinstitute.hellbender.utils.report.GATKReportVersion;

public final class GATKReport {
    public static final String RECAL_FILE = "input covariates table file for base quality score recalibration";
    public static final String GATKREPORT_HEADER_PREFIX = "#:GATKReport.";
    public static final GATKReportVersion LATEST_REPORT_VERSION = GATKReportVersion.V1_1;
    private static final String SEPARATOR = ":";
    private GATKReportVersion version = LATEST_REPORT_VERSION;
    private final NavigableMap<String, GATKReportTable> tables = new TreeMap<String, GATKReportTable>();

    public GATKReport() {
    }

    public GATKReport(String filename) {
        this(BucketUtils.openFile(filename));
    }

    public GATKReport(File file) {
        this(file.getPath());
    }

    public GATKReport(InputStream in) {
        this.loadReport(new InputStreamReader(in));
    }

    public GATKReport(GATKReportTable ... tables) {
        for (GATKReportTable table : tables) {
            this.addTable(table);
        }
    }

    public SortedSet<String> getReadGroups() {
        GATKReportTable reportTable = this.getTable("RecalTable0");
        TreeSet<String> readGroups = new TreeSet<String>();
        for (int i = 0; i < reportTable.getNumRows(); ++i) {
            readGroups.add(reportTable.get(i, "ReadGroup").toString());
        }
        return readGroups;
    }

    private void loadReport(Reader in) {
        String reportHeader;
        BufferedReader reader = new BufferedReader(in);
        try {
            reportHeader = reader.readLine();
        }
        catch (IOException e) {
            throw new UserException("Could not read input covariates table file for base quality score recalibration", e);
        }
        if (reportHeader == null) {
            throw new UserException("input covariates table file for base quality score recalibration is empty.");
        }
        this.version = GATKReportVersion.fromHeader(reportHeader);
        if (this.version.equals(GATKReportVersion.V0_1) || this.version.equals(GATKReportVersion.V0_2)) {
            throw new UserException("The GATK no longer supports reading legacy GATK Reports. Please use v1.0 or newer.");
        }
        int nTables = Integer.parseInt(reportHeader.split(SEPARATOR)[2]);
        for (int i = 0; i < nTables; ++i) {
            this.addTable(new GATKReportTable(reader, this.version));
        }
    }

    public void addTable(String tableName, String tableDescription, int numColumns) {
        this.addTable(tableName, tableDescription, numColumns, GATKReportTable.Sorting.DO_NOT_SORT);
    }

    public void addTable(String tableName, String tableDescription, int numColumns, GATKReportTable.Sorting sortingWay) {
        GATKReportTable table = new GATKReportTable(tableName, tableDescription, numColumns, sortingWay);
        this.tables.put(tableName, table);
    }

    public void addTable(GATKReportTable table) {
        this.tables.put(table.getTableName(), table);
    }

    public void addTables(List<GATKReportTable> gatkReportTableV2s) {
        for (GATKReportTable table : gatkReportTableV2s) {
            this.addTable(table);
        }
    }

    public GATKReportTable getTable(String tableName) {
        GATKReportTable table = (GATKReportTable)this.tables.get(tableName);
        if (table == null) {
            throw new GATKException("Table is not in GATKReport: " + tableName);
        }
        return table;
    }

    public void print(PrintStream out) {
        out.println(GATKREPORT_HEADER_PREFIX + (Object)((Object)this.getVersion()) + SEPARATOR + this.getTables().size());
        for (GATKReportTable table : this.tables.values()) {
            table.write(out);
        }
    }

    public void print(PrintStream out, GATKReportTable.Sorting sortingWay) {
        out.println(GATKREPORT_HEADER_PREFIX + (Object)((Object)this.getVersion()) + SEPARATOR + this.getTables().size());
        for (GATKReportTable table : this.tables.values()) {
            table.write(out, sortingWay);
        }
    }

    public Collection<GATKReportTable> getTables() {
        return this.tables.values();
    }

    public void concat(GATKReport input) {
        if (!this.isSameFormat(input)) {
            throw new GATKException("Failed to combine GATKReport, format doesn't match!");
        }
        for (Map.Entry table : this.tables.entrySet()) {
            ((GATKReportTable)table.getValue()).concat(input.getTable((String)table.getKey()));
        }
    }

    public GATKReportVersion getVersion() {
        return this.version;
    }

    public boolean isSameFormat(GATKReport report) {
        if (!this.version.equals(report.version)) {
            return false;
        }
        if (!this.tables.keySet().equals(report.tables.keySet())) {
            return false;
        }
        for (String tableName : this.tables.keySet()) {
            if (this.getTable(tableName).isSameFormat(report.getTable(tableName))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(GATKReport report) {
        if (!this.version.equals(report.version)) {
            return false;
        }
        if (!this.tables.keySet().equals(report.tables.keySet())) {
            return false;
        }
        for (String tableName : this.tables.keySet()) {
            if (this.getTable(tableName).equals(report.getTable(tableName))) continue;
            return false;
        }
        return true;
    }

    public static GATKReport newSimpleReport(String tableName, GATKReportTable.Sorting sorting, String ... columns) {
        return GATKReport.newSimpleReportWithDescription(tableName, "A simplified GATK table report", sorting, columns);
    }

    public static GATKReport newSimpleReportWithDescription(String tableName, String desc, GATKReportTable.Sorting sorting, String ... columns) {
        GATKReportTable table = new GATKReportTable(tableName, desc, columns.length, sorting);
        for (String column : columns) {
            table.addColumn(column, "");
        }
        GATKReport output = new GATKReport();
        output.addTable(table);
        return output;
    }

    public void addRow(Object ... values) {
        if (this.tables.size() != 1) {
            throw new GATKException("Cannot write a row to a complex GATK Report");
        }
        GATKReportTable table = this.tables.firstEntry().getValue();
        if (table.getNumColumns() != values.length) {
            throw new GATKException("The number of arguments in writeRow (" + values.length + ") must match the number of columns in the table (" + table.getNumColumns() + ")");
        }
        int rowIndex = table.getNumRows();
        for (int i = 0; i < values.length; ++i) {
            table.set(rowIndex, i, values[i]);
        }
    }
}

