/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.report;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.math.NumberUtils;
import org.broadinstitute.hellbender.utils.report.GATKReportColumnFormat;
import org.broadinstitute.hellbender.utils.report.GATKReportDataType;

public final class GATKReportColumn {
    private final String columnName;
    private final String format;
    private final GATKReportDataType dataType;
    private GATKReportColumnFormat columnFormat;
    private GATKReportColumnFormat.Alignment alignment = GATKReportColumnFormat.Alignment.RIGHT;
    private int maxWidth = 0;
    private static final Collection<String> RIGHT_ALIGN_STRINGS = Arrays.asList("null", "NA", String.valueOf(Double.POSITIVE_INFINITY), String.valueOf(Double.NEGATIVE_INFINITY), String.valueOf(Double.NaN));

    public GATKReportColumn(String columnName, String format) {
        this.columnName = columnName;
        this.maxWidth = columnName.length();
        if (format.equals("")) {
            this.format = "%s";
            this.dataType = GATKReportDataType.Unknown;
        } else {
            this.format = format;
            this.dataType = GATKReportDataType.fromFormatString(format);
        }
    }

    public GATKReportColumnFormat getColumnFormat() {
        if (this.columnFormat != null) {
            return this.columnFormat;
        }
        this.columnFormat = new GATKReportColumnFormat(this.maxWidth, this.alignment);
        return this.columnFormat;
    }

    protected static boolean isRightAlign(String value) {
        return value == null || RIGHT_ALIGN_STRINGS.contains(value) || NumberUtils.isCreatable((String)value.trim());
    }

    @VisibleForTesting
    protected String formatValue(Object obj) {
        String value = obj == null ? "null" : (this.dataType.equals((Object)GATKReportDataType.Unknown) && (obj instanceof Double || obj instanceof Float) ? String.format("%.8f", obj) : (obj instanceof Double || obj instanceof Float ? (Double.isFinite(Double.parseDouble(obj.toString())) ? String.format(this.format, obj) : obj.toString()) : String.format(this.format, obj)));
        return value;
    }

    public GATKReportDataType getDataType() {
        return this.dataType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getFormat() {
        return this.dataType.equals((Object)GATKReportDataType.Unknown) ? "%s" : this.format;
    }

    public void updateFormatting(Object value) {
        String formatted;
        if (value != null && !(formatted = this.formatValue(value)).isEmpty()) {
            this.updateMaxWidth(formatted);
            this.updateFormat(formatted);
        }
    }

    private void updateMaxWidth(String formatted) {
        this.maxWidth = Math.max(formatted.length(), this.maxWidth);
    }

    private void updateFormat(String formatted) {
        if (this.alignment == GATKReportColumnFormat.Alignment.RIGHT) {
            this.alignment = GATKReportColumn.isRightAlign(formatted) ? GATKReportColumnFormat.Alignment.RIGHT : GATKReportColumnFormat.Alignment.LEFT;
        }
    }
}

