/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.runtime;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;

public class AsynchronousStreamWriter<T> {
    private static final Logger logger = LogManager.getLogger(AsynchronousStreamWriter.class);
    final ExecutorService executorService;
    final OutputStream streamWriter;
    final Function<T, ByteArrayOutputStream> itemSerializer;
    Future<Integer> previousBatch;
    public static Function<String, ByteArrayOutputStream> stringSerializer = item -> {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(item.getBytes());
        }
        catch (IOException e) {
            throw new GATKException("IOException converting bytes for serialization", e);
        }
        return bos;
    };

    public AsynchronousStreamWriter(ExecutorService executorService, OutputStream streamWriter, Function<T, ByteArrayOutputStream> itemSerializer) {
        Utils.nonNull(executorService);
        Utils.nonNull(streamWriter);
        Utils.nonNull(itemSerializer);
        this.streamWriter = streamWriter;
        this.executorService = executorService;
        this.itemSerializer = itemSerializer;
        this.previousBatch = null;
    }

    public void startBatchWrite(List<T> batchList) {
        Utils.nonNull(batchList);
        Utils.nonEmpty(batchList);
        if (this.previousBatch != null) {
            throw new IllegalStateException("Previous batch not yet complete");
        }
        this.previousBatch = this.executorService.submit(() -> {
            try {
                Integer batchSize = batchList.size();
                for (int i = 0; i < batchList.size(); ++i) {
                    Object element = batchList.get(i);
                    this.itemSerializer.apply(element).writeTo(this.streamWriter);
                }
                this.streamWriter.flush();
                return batchSize;
            }
            catch (IOException e) {
                throw new GATKException("IOException converting bytes for serialization", e);
            }
        });
    }

    public Future<Integer> waitForPreviousBatchCompletion() {
        Future<Integer> lastCompleteBatch = this.previousBatch;
        if (this.previousBatch != null) {
            try {
                try {
                    this.previousBatch.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new GATKException("Interrupted during background stream write", e);
                }
                this.streamWriter.flush();
            }
            catch (IOException e) {
                throw new GATKException("IOException waiting for asynchronous batch completion", e);
            }
            this.previousBatch = null;
        }
        return lastCompleteBatch;
    }

    public boolean terminate() {
        boolean isCancelled = true;
        if (this.previousBatch != null) {
            logger.warn("Cancelling outstanding asynchronous writing");
            isCancelled = this.previousBatch.cancel(true);
        }
        this.previousBatch = null;
        return isCancelled;
    }
}

