/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.runtime;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.EnumMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.io.HardThresholdingOutputStream;
import org.broadinstitute.hellbender.utils.runtime.OutputStreamSettings;
import org.broadinstitute.hellbender.utils.runtime.StreamLocation;
import org.broadinstitute.hellbender.utils.runtime.StreamOutput;

public class CapturedStreamOutput
extends StreamOutput {
    protected final InputStream processStream;
    private final EnumMap<StreamLocation, OutputStream> outputStreams = new EnumMap(StreamLocation.class);
    public static final int STREAM_BLOCK_TRANSFER_SIZE = 4096;
    protected final ByteArrayOutputStream bufferStream;
    private boolean bufferTruncated = false;

    public CapturedStreamOutput(OutputStreamSettings settings, InputStream processStream, PrintStream standardStream) {
        this.processStream = processStream;
        int bufferSize = settings.getBufferSize();
        this.bufferStream = bufferSize < 0 ? new ByteArrayOutputStream() : new ByteArrayOutputStream(bufferSize);
        for (StreamLocation location : settings.getStreamLocations()) {
            Object outputStream;
            switch (location) {
                case Buffer: {
                    if (bufferSize < 0) {
                        outputStream = this.bufferStream;
                        break;
                    }
                    outputStream = new HardThresholdingOutputStream(bufferSize){

                        protected OutputStream getStream() {
                            return CapturedStreamOutput.this.bufferTruncated ? NullOutputStream.NULL_OUTPUT_STREAM : CapturedStreamOutput.this.bufferStream;
                        }

                        protected void thresholdReached() {
                            CapturedStreamOutput.this.bufferTruncated = true;
                        }
                    };
                    break;
                }
                case File: {
                    try {
                        outputStream = new FileOutputStream(settings.getOutputFile(), settings.isAppendFile());
                        break;
                    }
                    catch (IOException e) {
                        throw new UserException.BadInput(e.getMessage());
                    }
                }
                case Standard: {
                    outputStream = standardStream;
                    break;
                }
                default: {
                    throw new GATKException("Unexpected stream location: " + (Object)((Object)location));
                }
            }
            this.outputStreams.put(location, (OutputStream)outputStream);
        }
    }

    @Override
    public byte[] getBufferBytes() {
        return this.bufferStream.toByteArray();
    }

    @Override
    public boolean isBufferTruncated() {
        return this.bufferTruncated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() throws IOException {
        int readCount = 0;
        try {
            byte[] buf = new byte[4096];
            while ((readCount = this.processStream.read(buf)) >= 0) {
                for (OutputStream outputStream : this.outputStreams.values()) {
                    outputStream.write(buf, 0, readCount);
                }
            }
        }
        finally {
            for (StreamLocation location : this.outputStreams.keySet()) {
                OutputStream outputStream;
                outputStream = this.outputStreams.get((Object)location);
                outputStream.flush();
                if (location == StreamLocation.Standard) continue;
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
        }
    }
}

