/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.runtime.CapturedStreamOutput;
import org.broadinstitute.hellbender.utils.runtime.OutputStreamSettings;
import org.broadinstitute.hellbender.utils.runtime.StreamLocation;

public final class CapturedStreamOutputSnapshot
extends CapturedStreamOutput {
    public CapturedStreamOutputSnapshot(OutputStreamSettings settings, InputStream processStream, PrintStream standardStream) {
        super(settings, processStream, standardStream);
        Utils.validate(!settings.getStreamLocations().contains((Object)StreamLocation.Standard), "Stream snapshots can't go to standard out");
        Utils.validate(!settings.getStreamLocations().contains((Object)StreamLocation.File), "Stream snapshots can't go to a file");
    }

    @Override
    public void read() throws IOException {
        try {
            byte[] buf = new byte[4096];
            do {
                int readCount;
                if ((readCount = this.processStream.read(buf)) == -1) {
                    return;
                }
                if (readCount < 0) continue;
                this.bufferStream.write(buf, 0, readCount);
            } while (this.processStream.available() > 0);
        }
        finally {
            this.bufferStream.flush();
        }
    }
}

