/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.runtime;

import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.runtime.StreamLocation;

public final class InputStreamSettings {
    private final EnumSet<StreamLocation> streamLocations = EnumSet.noneOf(StreamLocation.class);
    private byte[] inputBuffer;
    private File inputFile;

    public Set<StreamLocation> getStreamLocations() {
        return Collections.unmodifiableSet(this.streamLocations);
    }

    public byte[] getInputBuffer() {
        return this.inputBuffer;
    }

    public void setInputBuffer(String inputBuffer) {
        Utils.nonNull(inputBuffer, "inputBuffer cannot be null");
        this.streamLocations.add(StreamLocation.Buffer);
        this.inputBuffer = inputBuffer.getBytes();
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        Utils.nonNull(inputFile, "inputFile cannot be null");
        this.streamLocations.add(StreamLocation.File);
        this.inputFile = inputFile;
    }
}

