/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.runtime;

import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.broadinstitute.hellbender.utils.runtime.StreamLocation;

public final class OutputStreamSettings {
    private final EnumSet<StreamLocation> streamLocations = EnumSet.noneOf(StreamLocation.class);
    private int bufferSize;
    private File outputFile;
    private boolean appendFile;

    public Set<StreamLocation> getStreamLocations() {
        return Collections.unmodifiableSet(this.streamLocations);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.streamLocations.add(StreamLocation.Buffer);
        this.bufferSize = bufferSize;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public boolean isAppendFile() {
        return this.appendFile;
    }

    public void setOutputFile(File outputFile) {
        this.setOutputFile(outputFile, false);
    }

    public void setOutputFile(File outputFile, boolean append) {
        if (outputFile == null) {
            throw new IllegalArgumentException("outputFile cannot be null");
        }
        this.streamLocations.add(StreamLocation.File);
        this.outputFile = outputFile;
        this.appendFile = append;
    }

    public void printStandard(boolean print) {
        if (print) {
            this.streamLocations.add(StreamLocation.Standard);
        } else {
            this.streamLocations.remove((Object)StreamLocation.Standard);
        }
    }
}

