/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.runtime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.runtime.CapturedStreamOutput;
import org.broadinstitute.hellbender.utils.runtime.InputStreamSettings;
import org.broadinstitute.hellbender.utils.runtime.ProcessControllerBase;
import org.broadinstitute.hellbender.utils.runtime.ProcessOutput;
import org.broadinstitute.hellbender.utils.runtime.ProcessSettings;
import org.broadinstitute.hellbender.utils.runtime.StreamLocation;
import org.broadinstitute.hellbender.utils.runtime.StreamOutput;

public final class ProcessController
extends ProcessControllerBase<CapturedStreamOutput> {
    private static final Logger logger = LogManager.getLogger(ProcessController.class);
    private static final ThreadLocal<ProcessController> threadProcessController = new ThreadLocal<ProcessController>(){

        @Override
        protected ProcessController initialValue() {
            return new ProcessController();
        }
    };

    public static ProcessController getThreadLocal() {
        if (ProcessController.threadProcessController.get().destroyed) {
            threadProcessController.remove();
        }
        return threadProcessController.get();
    }

    public static int exec(String[] command) {
        ProcessController controller = ProcessController.getThreadLocal();
        return controller.exec(new ProcessSettings(command)).getExitValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessOutput exec(ProcessSettings settings) {
        int exitCode;
        StreamOutput stderr;
        StreamOutput stdout;
        this.launchProcess(settings);
        try {
            this.stdOutFuture = executorService.submit(new ProcessControllerBase.OutputCapture((ProcessControllerBase)this, new CapturedStreamOutput(settings.getStdoutSettings(), this.process.getInputStream(), System.out), ProcessControllerBase.ProcessStream.STDOUT, this.getClass().getSimpleName(), this.controllerId));
            this.stdErrFuture = executorService.submit(new ProcessControllerBase.OutputCapture((ProcessControllerBase)this, new CapturedStreamOutput(settings.getStderrSettings(), this.process.getErrorStream(), System.err), ProcessControllerBase.ProcessStream.STDERR, this.getClass().getSimpleName(), this.controllerId));
            InputStreamSettings stdinSettings = settings.getStdinSettings();
            Set<StreamLocation> streamLocations = stdinSettings.getStreamLocations();
            if (!streamLocations.isEmpty()) {
                try {
                    OutputStream stdinStream = this.process.getOutputStream();
                    for (StreamLocation location : streamLocations) {
                        InputStream inputStream;
                        switch (location) {
                            case Buffer: {
                                inputStream = new ByteArrayInputStream(stdinSettings.getInputBuffer());
                                break;
                            }
                            case File: {
                                try {
                                    inputStream = FileUtils.openInputStream((File)stdinSettings.getInputFile());
                                    break;
                                }
                                catch (IOException e) {
                                    throw new UserException.BadInput(e.getMessage());
                                }
                            }
                            case Standard: {
                                inputStream = System.in;
                                break;
                            }
                            default: {
                                throw new GATKException("Unexpected stream location: " + (Object)((Object)location));
                            }
                        }
                        try {
                            IOUtils.copy((InputStream)inputStream, (OutputStream)stdinStream);
                        }
                        finally {
                            if (location == StreamLocation.Standard) continue;
                            IOUtils.closeQuietly((InputStream)inputStream);
                        }
                    }
                    stdinStream.flush();
                }
                catch (IOException e) {
                    throw new GATKException("Error writing to stdin on command: " + settings.getCommandString(), e);
                }
            }
            try {
                this.process.getOutputStream().close();
                this.process.waitFor();
                stdout = (StreamOutput)this.stdOutFuture.get();
                this.stdOutFuture = null;
                stderr = (StreamOutput)this.stdErrFuture.get();
                this.stdErrFuture = null;
            }
            catch (ExecutionException e) {
                throw new GATKException("Execution exception during process output retrieval", e);
            }
            catch (IOException e) {
                throw new GATKException("Unable to close stdin on command: " + settings.getCommandString(), e);
            }
            catch (InterruptedException e) {
                throw new GATKException("Process interrupted", e);
            }
        }
        finally {
            exitCode = this.process.exitValue();
            this.process = null;
            running.remove(this);
        }
        return new ProcessOutput(exitCode, stdout, stderr);
    }

    @Override
    protected void tryCleanShutdown() {
        boolean isCancelled;
        this.destroyed = true;
        if (this.stdErrFuture != null && !(isCancelled = this.stdErrFuture.cancel(true))) {
            logger.error("Failure cancelling stderr task");
        }
        if (this.stdOutFuture != null && !(isCancelled = this.stdOutFuture.cancel(true))) {
            logger.error("Failure cancelling stdout task");
        }
        if (this.process != null) {
            this.process.destroy();
            IOUtils.closeQuietly((InputStream)this.process.getInputStream());
            IOUtils.closeQuietly((InputStream)this.process.getErrorStream());
        }
    }
}

