/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.runtime;

import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.runtime.StreamingToolConstants;

public class ProcessControllerAckResult {
    private final boolean isPositiveAck;
    private final String message;
    private static String displayMessageFormat = "%s received\n\n";
    private static String ACK_LOG_MESSAGE = String.format(displayMessageFormat, StreamingToolConstants.STREAMING_ACK_MESSAGE);
    private static String NCK_LOG_MESSAGE = String.format(displayMessageFormat, StreamingToolConstants.STREAMING_NCK_MESSAGE);
    private static String NCK_WITH_MESSAGE_LOG_MESSAGE = String.format(displayMessageFormat, StreamingToolConstants.STREAMING_NCK_WITH_MESSAGE_MESSAGE);

    public ProcessControllerAckResult(boolean isPositiveAck) {
        this.isPositiveAck = isPositiveAck;
        this.message = null;
    }

    public ProcessControllerAckResult(String nckMessage) {
        this.isPositiveAck = false;
        this.message = nckMessage;
    }

    public boolean isPositiveAck() {
        return this.isPositiveAck;
    }

    public boolean hasMessage() {
        return !this.isPositiveAck() && !this.message.isEmpty();
    }

    public String getNegativeACKMessage() {
        if (this.isPositiveAck()) {
            throw new GATKException("Can only retrieve messages for negative acknowledgements");
        }
        return this.message;
    }

    public String getDisplayMessage() {
        if (this.isPositiveAck()) {
            return ACK_LOG_MESSAGE;
        }
        if (this.hasMessage()) {
            return String.format("%s: %s", NCK_WITH_MESSAGE_LOG_MESSAGE, this.getNegativeACKMessage());
        }
        return NCK_LOG_MESSAGE;
    }
}

