/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.runtime;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.runtime.CapturedStreamOutput;
import org.broadinstitute.hellbender.utils.runtime.ProcessSettings;

public abstract class ProcessControllerBase<CAPTURE_POLICY extends CapturedStreamOutput> {
    private static final Logger logger = LogManager.getLogger(ProcessControllerBase.class);
    protected static final Set<ProcessControllerBase<?>> running = Collections.synchronizedSet(new LinkedHashSet());
    protected static final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread newThread = Executors.defaultThreadFactory().newThread(r);
            newThread.setDaemon(true);
            newThread.setName("GATKProcessController");
            return newThread;
        }
    });
    protected Process process;
    protected Future<CAPTURE_POLICY> stdOutFuture;
    protected Future<CAPTURE_POLICY> stdErrFuture;
    protected boolean destroyed = false;
    private static int nextControllerId = 0;
    protected final int controllerId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessControllerBase() {
        Set<ProcessControllerBase<?>> set = running;
        synchronized (set) {
            this.controllerId = nextControllerId++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ProcessControllerBase<?>> getRunning() {
        Set<ProcessControllerBase<?>> set = running;
        synchronized (set) {
            return new LinkedHashSet(running);
        }
    }

    protected Process launchProcess(ProcessSettings settings) {
        Utils.validate(!this.destroyed, "This controller was destroyed");
        ProcessBuilder builder = new ProcessBuilder(settings.getCommand());
        builder.directory(settings.getDirectory());
        Map<String, String> settingsEnvironment = settings.getEnvironment();
        if (settingsEnvironment != null) {
            Map<String, String> builderEnvironment = builder.environment();
            builderEnvironment.clear();
            builderEnvironment.putAll(settingsEnvironment);
        }
        builder.redirectErrorStream(settings.isRedirectErrorStream());
        try {
            this.process = builder.start();
            running.add(this);
        }
        catch (IOException e) {
            String message = String.format("Unable to start command: %s\nReason: %s", StringUtils.join(builder.command(), (String)" "), e.getMessage());
            throw new GATKException(message, e);
        }
        return this.process;
    }

    @VisibleForTesting
    public Process getProcess() {
        return this.process;
    }

    abstract void tryCleanShutdown();

    protected void finalize() throws Throwable {
        try {
            this.tryCleanShutdown();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        super.finalize();
    }

    protected class OutputCapture
    implements Callable<CAPTURE_POLICY> {
        private final CAPTURE_POLICY capturedProcessStream;
        private final ProcessStream key;
        private final String controllerContextName;
        final /* synthetic */ ProcessControllerBase this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public OutputCapture(CAPTURE_POLICY capturedProcessStream, ProcessStream key, String className, int controllerId) {
            this.this$0 = (ProcessControllerBase)this$0;
            this.key = key;
            this.capturedProcessStream = capturedProcessStream;
            this.controllerContextName = String.format("OutputCapture-%s-%d-%s", className, controllerId, key.name().toLowerCase());
        }

        @Override
        public CAPTURE_POLICY call() {
            try {
                ((CapturedStreamOutput)this.capturedProcessStream).read();
            }
            catch (IOException e) {
                logger.error("Error reading process output", (Throwable)e);
            }
            return this.capturedProcessStream;
        }
    }

    protected static enum ProcessStream {
        STDOUT,
        STDERR;

    }
}

