/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.runtime;

import org.broadinstitute.hellbender.utils.runtime.StreamOutput;

public final class ProcessOutput {
    private final int exitValue;
    private final StreamOutput stdout;
    private final StreamOutput stderr;

    public ProcessOutput(int exitValue, StreamOutput stdout, StreamOutput stderr) {
        this.exitValue = exitValue;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public StreamOutput getStdout() {
        return this.stdout;
    }

    public StreamOutput getStderr() {
        return this.stderr;
    }

    public String getStatusSummary(boolean includeStdout) {
        StringBuilder message = new StringBuilder();
        if (this.getExitValue() == 137) {
            message.append("\nThe exit code indicates that the process was terminated. This may mean the process requires additional memory.\n");
        }
        if (includeStdout) {
            message.append(String.format("\nStdout: %s\nStderr: %s", this.getStdout().getBufferString(), this.getStderr().getBufferString()));
        }
        return message.toString();
    }
}

