/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.runtime;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.runtime.InputStreamSettings;
import org.broadinstitute.hellbender.utils.runtime.OutputStreamSettings;

public final class ProcessSettings {
    private String[] command;
    private Map<String, String> environment;
    private File directory;
    private boolean redirectErrorStream;
    private final InputStreamSettings stdinSettings;
    private final OutputStreamSettings stdoutSettings;
    private final OutputStreamSettings stderrSettings;
    private boolean cleanUpTemps;

    public ProcessSettings(String[] command) {
        this(command, false, null, null, null, null, null);
    }

    public ProcessSettings(String[] command, boolean redirectErrorStream, File directory, Map<String, String> environment, InputStreamSettings stdinSettings, OutputStreamSettings stdoutSettings, OutputStreamSettings stderrSettings) {
        this.command = this.checkCommand(command);
        this.redirectErrorStream = redirectErrorStream;
        this.directory = directory;
        this.environment = environment;
        this.stdinSettings = this.checkSettings(stdinSettings);
        this.stdoutSettings = this.checkSettings(stdoutSettings);
        this.stderrSettings = this.checkSettings(stderrSettings);
    }

    public String[] getCommand() {
        return this.command;
    }

    public String getCommandString() {
        return StringUtils.join((Object[])this.command, (String)" ");
    }

    public void setCommand(String[] command) {
        this.command = this.checkCommand(command);
    }

    public boolean isRedirectErrorStream() {
        return this.redirectErrorStream;
    }

    public void setRedirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public InputStreamSettings getStdinSettings() {
        return this.stdinSettings;
    }

    public OutputStreamSettings getStdoutSettings() {
        return this.stdoutSettings;
    }

    public OutputStreamSettings getStderrSettings() {
        return this.stderrSettings;
    }

    protected String[] checkCommand(String[] command) {
        Utils.nonNull(command);
        Utils.containsNoNull(Arrays.asList(command), "Command is not allowed to contain nulls");
        return command;
    }

    protected InputStreamSettings checkSettings(InputStreamSettings settings) {
        return settings == null ? new InputStreamSettings() : settings;
    }

    protected OutputStreamSettings checkSettings(OutputStreamSettings settings) {
        return settings == null ? new OutputStreamSettings() : settings;
    }
}

