/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.broadinstitute.hellbender.utils.Utils;
import picard.cmdline.CommandLineProgram;

public final class RuntimeUtils {
    public static final String[] PATHS;

    public static File which(String executable) {
        for (String path : PATHS) {
            File file = new File(path, executable);
            if (!file.exists()) continue;
            return file.getAbsoluteFile();
        }
        return null;
    }

    public static String toolDisplayName(Class<?> toolClass) {
        Utils.nonNull(toolClass, "A valid class is required to get a display name");
        String picardToolSuffix = " (Picard)";
        Class<CommandLineProgram> picardCommandLineProgramClass = CommandLineProgram.class;
        return picardCommandLineProgramClass.isAssignableFrom(toolClass) ? toolClass.getSimpleName() + " (Picard)" : toolClass.getSimpleName();
    }

    public static String getToolkitName(Class<?> clazz) {
        String implementationTitle = clazz.getPackage().getImplementationTitle();
        return implementationTitle != null ? implementationTitle : clazz.getPackage().getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Manifest getManifest(Class<?> clazz) {
        URL resourceURL = clazz.getResource(clazz.getSimpleName() + ".class");
        if (resourceURL == null) {
            return null;
        }
        String classPath = resourceURL.toString();
        if (!classPath.startsWith("jar")) return null;
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try (InputStream manifestStream = new URL(manifestPath).openStream();){
            Manifest manifest = new Manifest(manifestStream);
            return manifest;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getVersion(Class<?> clazz) {
        String versionString = clazz.getPackage().getImplementationVersion();
        return versionString != null ? versionString : "Unavailable";
    }

    static {
        String path = System.getenv("PATH");
        if (path == null) {
            path = System.getenv("path");
        }
        PATHS = path == null ? new String[0] : StringUtils.split((String)path, (char)File.pathSeparatorChar);
    }
}

