/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.runtime;

import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.runtime.ProcessController;
import org.broadinstitute.hellbender.utils.runtime.ProcessOutput;
import org.broadinstitute.hellbender.utils.runtime.ProcessSettings;
import org.broadinstitute.hellbender.utils.runtime.RuntimeUtils;
import org.broadinstitute.hellbender.utils.runtime.ScriptExecutorException;

public abstract class ScriptExecutor {
    private static final Logger logger = LogManager.getLogger(ScriptExecutor.class);
    protected final String externalScriptExecutableName;
    protected boolean ignoreExceptions = false;
    private final File externalScriptExecutablePath;
    private String[] commandLineArgs;

    public ScriptExecutor(String externalScriptExecutableName) {
        Utils.nonNull(externalScriptExecutableName);
        this.externalScriptExecutableName = externalScriptExecutableName;
        this.externalScriptExecutablePath = RuntimeUtils.which(externalScriptExecutableName);
    }

    public boolean externalExecutableExists() {
        return this.externalScriptExecutablePath != null;
    }

    public void setIgnoreExceptions(boolean ignoreExceptions) {
        this.ignoreExceptions = ignoreExceptions;
    }

    public abstract String getApproximateCommandLine();

    protected void executableMissing() {
        throw new UserException.CannotExecuteScript(this.externalScriptExecutableName, String.format("Please add the %s directory to your environment ${PATH}", this.externalScriptExecutableName));
    }

    public abstract ScriptExecutorException getScriptException(String var1);

    public String getExceptionMessageFromScriptError(ProcessOutput po) {
        Utils.nonNull(po, "process output cannot be null");
        int exitValue = po.getExitValue();
        String commandLineMessage = String.format("\n%s exited with %d\nCommand Line: %s", this.externalScriptExecutableName, exitValue, String.join((CharSequence)" ", Utils.nonNull(this.commandLineArgs, "command line args have not been set yet")));
        boolean outputStdout = !logger.isDebugEnabled();
        return commandLineMessage.concat(po.getStatusSummary(outputStdout));
    }

    protected boolean executeCuratedArgs(String[] commandLineArguments) {
        try {
            ProcessOutput po = this.executeCuratedArgsAndGetOutput(commandLineArguments);
            if (po == null) {
                return false;
            }
            int exitValue = po.getExitValue();
            logger.debug("Result: " + exitValue);
            if (exitValue != 0) {
                throw this.getScriptException(this.getExceptionMessageFromScriptError(po));
            }
            return true;
        }
        catch (GATKException e) {
            if (!this.ignoreExceptions) {
                throw e;
            }
            logger.warn(e.getMessage());
            return false;
        }
    }

    protected ProcessOutput executeCuratedArgsAndGetOutput(String[] commandLineArguments) {
        Utils.nonNull(commandLineArguments, "Command line arguments cannot be null");
        this.commandLineArgs = commandLineArguments;
        if (!this.externalExecutableExists()) {
            if (!this.ignoreExceptions) {
                this.executableMissing();
            } else {
                logger.warn("Skipping: " + this.getApproximateCommandLine());
                return null;
            }
        }
        ProcessSettings processSettings = new ProcessSettings(this.commandLineArgs);
        if (logger.isDebugEnabled()) {
            processSettings.getStdoutSettings().printStandard(true);
            processSettings.getStderrSettings().printStandard(true);
        } else {
            processSettings.getStdoutSettings().setBufferSize(8192);
            processSettings.getStderrSettings().setBufferSize(8192);
        }
        ProcessController controller = ProcessController.getThreadLocal();
        if (logger.isDebugEnabled()) {
            logger.debug("Executing:");
            for (String arg : this.commandLineArgs) {
                logger.debug("  " + arg);
            }
        }
        return controller.exec(processSettings);
    }
}

