/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.samples;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeType;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.hellbender.utils.samples.Sample;
import org.broadinstitute.hellbender.utils.samples.SampleDB;

public class MendelianViolation {
    private List<String> violationFamilies = new ArrayList<String>();
    private int noCall = 0;
    private int familyCalled = 0;
    private int varFamilyCalled = 0;
    private int lowQual = 0;
    private EnumMap<GenotypeType, EnumMap<GenotypeType, EnumMap<GenotypeType, Integer>>> inheritance;
    private int violations_total = 0;
    private final boolean allCalledOnly;
    private final double minGenotypeQuality;
    private final boolean abortOnSampleNotFound;

    public MendelianViolation(double minGenotypeQualityP) {
        this(minGenotypeQualityP, true, false);
    }

    public MendelianViolation(double minGenotypeQualityP, boolean abortOnSampleNotFound, boolean completeTriosOnly) {
        this.minGenotypeQuality = minGenotypeQualityP;
        this.abortOnSampleNotFound = abortOnSampleNotFound;
        this.createInheritanceMap();
        this.allCalledOnly = completeTriosOnly;
    }

    public int getParentsRefRefChildHet() {
        return this.inheritance.get(GenotypeType.HOM_REF).get(GenotypeType.HOM_REF).get(GenotypeType.HET);
    }

    private void resetCounts() {
        this.noCall = 0;
        this.lowQual = 0;
        this.familyCalled = 0;
        this.varFamilyCalled = 0;
        this.violations_total = 0;
        this.violationFamilies.clear();
        this.clearInheritanceMap();
    }

    public boolean isViolation(Sample mother, Sample father, Sample child, VariantContext vc) {
        this.resetCounts();
        this.updateViolations(mother.getFamilyID(), mother.getID(), father.getID(), child.getID(), vc);
        return this.violations_total > 0;
    }

    protected void updateViolations(String familyId, String motherId, String fatherId, String childId, VariantContext vc) {
        Genotype gMom = vc.getGenotype(motherId);
        Genotype gDad = vc.getGenotype(fatherId);
        Genotype gChild = vc.getGenotype(childId);
        if (gMom == null || gDad == null || gChild == null) {
            if (this.abortOnSampleNotFound) {
                throw new IllegalArgumentException(String.format("Variant %s:%d: Missing genotypes for family %s: mom=%s dad=%s family=%s", vc.getContig(), vc.getStart(), familyId, motherId, fatherId, childId));
            }
            return;
        }
        if (!(!this.allCalledOnly || gMom.isCalled() && gDad.isCalled() && gChild.isCalled())) {
            ++this.noCall;
        } else if (!gMom.isCalled() && !gDad.isCalled() || !gChild.isCalled()) {
            ++this.noCall;
        } else if (this.minGenotypeQuality > 0.0 && ((double)gMom.getGQ() < this.minGenotypeQuality || (double)gDad.getGQ() < this.minGenotypeQuality || (double)gChild.getGQ() < this.minGenotypeQuality)) {
            ++this.lowQual;
        } else {
            ++this.familyCalled;
            if (!(gMom.isHomRef() && gDad.isHomRef() && gChild.isHomRef())) {
                ++this.varFamilyCalled;
            }
            if (MendelianViolation.isViolation(gMom, gDad, gChild)) {
                this.violationFamilies.add(familyId);
                ++this.violations_total;
            }
            int count = this.inheritance.get(gMom.getType()).get(gDad.getType()).get(gChild.getType());
            this.inheritance.get(gMom.getType()).get(gDad.getType()).put(gChild.getType(), count + 1);
        }
    }

    public int countFamilyViolations(SampleDB sampleDB, Set<String> sampleIDs, VariantContext vc) {
        this.resetCounts();
        Map<String, Set<Sample>> families = sampleDB.getFamilies(sampleIDs);
        for (Set<Sample> family : families.values()) {
            for (Sample sample : family) {
                if (sampleDB.getParents(sample).isEmpty()) continue;
                this.updateViolations(sample.getFamilyID(), sample.getMaternalID(), sample.getPaternalID(), sample.getID(), vc);
            }
        }
        return this.violations_total;
    }

    public static boolean isViolation(Genotype gMom, Genotype gDad, Genotype gChild) {
        if (gChild.isNoCall()) {
            return false;
        }
        if (gMom.isHomRef() && gDad.isHomRef() && gChild.isHomRef()) {
            return false;
        }
        if (!gMom.isCalled()) {
            return gDad.isHomRef() && gChild.isHomVar() || gDad.isHomVar() && gChild.isHomRef();
        }
        if (!gDad.isCalled()) {
            return gMom.isHomRef() && gChild.isHomVar() || gMom.isHomVar() && gChild.isHomRef();
        }
        Allele childRef = (Allele)gChild.getAlleles().get(0);
        return !(gMom.getAlleles().contains(childRef) && gDad.getAlleles().contains(gChild.getAlleles().get(1)) || gMom.getAlleles().contains(gChild.getAlleles().get(1)) && gDad.getAlleles().contains(childRef));
    }

    private void createInheritanceMap() {
        this.inheritance = new EnumMap(GenotypeType.class);
        for (GenotypeType mType : GenotypeType.values()) {
            this.inheritance.put(mType, new EnumMap(GenotypeType.class));
            for (GenotypeType dType : GenotypeType.values()) {
                this.inheritance.get(mType).put(dType, new EnumMap(GenotypeType.class));
                for (GenotypeType cType : GenotypeType.values()) {
                    this.inheritance.get(mType).get(dType).put(cType, 0);
                }
            }
        }
    }

    private void clearInheritanceMap() {
        for (GenotypeType mType : GenotypeType.values()) {
            for (GenotypeType dType : GenotypeType.values()) {
                for (GenotypeType cType : GenotypeType.values()) {
                    this.inheritance.get(mType).get(dType).put(cType, 0);
                }
            }
        }
    }

    public int getFamilyCalledCount() {
        return this.familyCalled;
    }

    public int getVarFamilyCalledCount() {
        return this.varFamilyCalled;
    }

    public int getFamilyNoCallCount() {
        return this.noCall;
    }

    public int getFamilyLowQualsCount() {
        return this.lowQual;
    }

    public int getViolationsCount() {
        return this.violations_total;
    }

    protected EnumMap<GenotypeType, EnumMap<GenotypeType, EnumMap<GenotypeType, Integer>>> getInheritance() {
        return this.inheritance;
    }
}

