/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.samples;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.samples.Affection;
import org.broadinstitute.hellbender.utils.samples.Sample;
import org.broadinstitute.hellbender.utils.samples.SampleDB;
import org.broadinstitute.hellbender.utils.samples.Sex;
import org.broadinstitute.hellbender.utils.text.XReadLines;

public final class PedReader {
    private static final Logger logger = LogManager.getLogger(PedReader.class);
    private static final String commentMarker = "#";
    private static final String MISSING_VALUE1 = "-9";
    private static final String MISSING_VALUE2 = "0";
    private static final String PHENOTYPE_UNAFFECTED = "1";
    private static final String PHENOTYPE_AFFECTED = "2";
    private static final String SEX_MALE = "1";
    private static final String SEX_FEMALE = "2";
    private static final Set<String> CATAGORICAL_TRAIT_VALUES = new LinkedHashSet<String>(Arrays.asList("-9", "0", "1", "2"));

    public final List<Sample> parse(File source, EnumSet<MissingPedField> missingFields, SampleDB sampleDB) throws FileNotFoundException {
        logger.info("Reading PED file " + source + " with missing fields: " + missingFields);
        return this.parse(new FileReader(source), missingFields, sampleDB);
    }

    public final List<Sample> parse(String source, EnumSet<MissingPedField> missingFields, SampleDB sampleDB) {
        logger.warn("Reading PED string: \"" + source + "\" with missing fields: " + missingFields);
        return this.parse(new StringReader(source.replace(";", String.format("%n", new Object[0]))), missingFields, sampleDB);
    }

    private List<String[]> splitLines(Reader reader, List<String> lines, int nExpectedFields) {
        int lineNo = 1;
        ArrayList<String[]> splits = new ArrayList<String[]>(lines.size());
        for (String line : lines) {
            if (line.startsWith(commentMarker) || line.trim().equals("")) continue;
            String[] parts = line.split("\\s+");
            if (parts.length != nExpectedFields) {
                throw new UserException(reader.toString() + "Bad PED line " + lineNo + ": wrong number of fields");
            }
            splits.add(parts);
            ++lineNo;
        }
        return splits;
    }

    private boolean isQT(List<String[]> lineParts, int phenotypePos) {
        boolean isQT = false;
        for (String[] parts : lineParts) {
            if (phenotypePos == -1) continue;
            isQT = isQT || !CATAGORICAL_TRAIT_VALUES.contains(parts[phenotypePos]);
        }
        logger.info("Phenotype is other? " + isQT);
        return isQT;
    }

    private Sex determineSex(String[] parts, int sexPos) {
        Sex gender = Sex.UNKNOWN;
        if (sexPos != -1) {
            switch (parts[sexPos]) {
                case "1": {
                    gender = Sex.MALE;
                    break;
                }
                case "2": {
                    gender = Sex.FEMALE;
                    break;
                }
                default: {
                    gender = Sex.UNKNOWN;
                }
            }
        }
        return gender;
    }

    public final List<Sample> parse(Reader reader, EnumSet<MissingPedField> missingFields, SampleDB sampleDB) {
        List<String> lines;
        int familyPos = missingFields.contains((Object)MissingPedField.NO_FAMILY_ID) ? -1 : 0;
        int samplePos = familyPos + 1;
        int paternalPos = missingFields.contains((Object)MissingPedField.NO_PARENTS) ? -1 : samplePos + 1;
        int maternalPos = missingFields.contains((Object)MissingPedField.NO_PARENTS) ? -1 : paternalPos + 1;
        int sexPos = missingFields.contains((Object)MissingPedField.NO_SEX) ? -1 : Math.max(maternalPos, samplePos) + 1;
        int phenotypePos = missingFields.contains((Object)MissingPedField.NO_PHENOTYPE) ? -1 : Math.max(sexPos, Math.max(maternalPos, samplePos)) + 1;
        int nExpectedFields = IntStream.of(samplePos, paternalPos, maternalPos, sexPos, phenotypePos).max().getAsInt() + 1;
        try (XReadLines sourceReader = new XReadLines(reader, false, commentMarker);){
            lines = sourceReader.readLines();
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile("Error reading pedigree input");
        }
        List<String[]> lineParts = this.splitLines(reader, lines, nExpectedFields);
        boolean isQT = this.isQT(lineParts, phenotypePos);
        int lineNo = 1;
        ArrayList<Sample> samples = new ArrayList<Sample>(lineParts.size());
        for (String[] parts : lineParts) {
            String individualID = parts[samplePos];
            String familyID = familyPos == -1 ? null : PedReader.maybeMissing(parts[familyPos]);
            String paternalID = paternalPos == -1 ? null : PedReader.maybeMissing(parts[paternalPos]);
            String maternalID = maternalPos == -1 ? null : PedReader.maybeMissing(parts[maternalPos]);
            Sex sex = this.determineSex(parts, sexPos);
            Affection affection = Affection.UNKNOWN;
            String quantitativePhenotype = null;
            if (phenotypePos != -1) {
                if (isQT) {
                    if (parts[phenotypePos].equals(MISSING_VALUE1)) {
                        affection = Affection.UNKNOWN;
                    } else {
                        affection = Affection.OTHER;
                        quantitativePhenotype = parts[phenotypePos];
                    }
                } else {
                    switch (parts[phenotypePos]) {
                        case "-9": {
                            affection = Affection.UNKNOWN;
                            break;
                        }
                        case "0": {
                            affection = Affection.UNKNOWN;
                            break;
                        }
                        case "1": {
                            affection = Affection.UNAFFECTED;
                            break;
                        }
                        case "2": {
                            affection = Affection.AFFECTED;
                            break;
                        }
                        default: {
                            throw new GATKException("Unexpected phenotype type " + parts[phenotypePos] + " at line " + lineNo);
                        }
                    }
                }
            }
            Sample s = new Sample(individualID, familyID, paternalID, maternalID, sex, affection);
            samples.add(s);
            sampleDB.addSample(s);
            ++lineNo;
        }
        for (Sample sample : new ArrayList(samples)) {
            Sample mom;
            Sample dad = this.maybeAddImplicitSample(sampleDB, sample.getPaternalID(), sample.getFamilyID(), Sex.MALE);
            if (dad != null) {
                samples.add(dad);
            }
            if ((mom = this.maybeAddImplicitSample(sampleDB, sample.getMaternalID(), sample.getFamilyID(), Sex.FEMALE)) == null) continue;
            samples.add(mom);
        }
        return samples;
    }

    private static String maybeMissing(String string) {
        if (string.equals(MISSING_VALUE1) || string.equals(MISSING_VALUE2)) {
            return null;
        }
        return string;
    }

    private Sample maybeAddImplicitSample(SampleDB sampleDB, String id, String familyID, Sex gender) {
        if (id != null && sampleDB.getSample(id) == null) {
            Sample s = new Sample(id, familyID, null, null, gender);
            sampleDB.addSample(s);
            return s;
        }
        return null;
    }

    public static EnumSet<MissingPedField> parseMissingFieldTags(Object arg, List<String> tags) {
        EnumSet<MissingPedField> missingFields = EnumSet.noneOf(MissingPedField.class);
        for (String tag : tags) {
            try {
                missingFields.add(MissingPedField.valueOf(tag));
            }
            catch (IllegalArgumentException e) {
                throw new CommandLineException.BadArgumentValue(arg.toString(), "Unknown tag " + tag + " allowed values are " + MissingPedField.values());
            }
        }
        return missingFields;
    }

    protected static enum Field {
        FAMILY_ID,
        INDIVIDUAL_ID,
        PATERNAL_ID,
        MATERNAL_ID,
        GENDER,
        PHENOTYPE;

    }

    public static enum MissingPedField {
        NO_FAMILY_ID,
        NO_PARENTS,
        NO_SEX,
        NO_PHENOTYPE;

    }
}

