/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.samples;

import java.util.Comparator;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.samples.Affection;
import org.broadinstitute.hellbender.utils.samples.Sex;

public final class Sample
implements Comparable<Sample> {
    private final String familyID;
    private final String paternalID;
    private final String maternalID;
    private final Sex gender;
    private final String ID;
    private final Affection affection;

    public Sample(String ID, String familyID, String paternalID, String maternalID, Sex gender, Affection affection) {
        Utils.nonNull(ID, "ID is null");
        Utils.nonNull(gender, "sex is null");
        Utils.nonNull(affection, "affection is null");
        this.ID = ID;
        this.familyID = familyID;
        this.paternalID = paternalID;
        this.maternalID = maternalID;
        this.gender = gender;
        this.affection = affection;
    }

    public Sample(String ID, String familyID, String paternalID, String maternalID, Sex gender) {
        this(ID, familyID, paternalID, maternalID, gender, Affection.UNKNOWN);
    }

    public String getID() {
        return this.ID;
    }

    public String getFamilyID() {
        return this.familyID;
    }

    public String getPaternalID() {
        return this.paternalID;
    }

    public String getMaternalID() {
        return this.maternalID;
    }

    public Sex getSex() {
        return this.gender;
    }

    public Affection getAffection() {
        return this.affection;
    }

    public String toString() {
        return String.format("Sample %s fam=%s dad=%s mom=%s gender=%s affection=%s", new Object[]{this.ID, this.familyID, this.paternalID, this.maternalID, this.gender, this.affection});
    }

    @Override
    public int compareTo(Sample other) {
        int cmp = this.ID.compareTo(other.getID());
        if (0 == cmp) {
            Comparator<String> compStr = Comparator.nullsFirst(Comparator.comparing(String::toString));
            cmp = compStr.compare(this.familyID, other.getFamilyID());
            if (0 == cmp) {
                cmp = compStr.compare(this.paternalID, other.getPaternalID());
            }
            if (0 == cmp) {
                cmp = compStr.compare(this.maternalID, other.getMaternalID());
            }
            if (0 == cmp) {
                cmp = this.gender.compareTo(other.getSex());
            }
            if (0 == cmp) {
                cmp = this.affection.compareTo(other.getAffection());
            }
        }
        return cmp;
    }

    public int hashCode() {
        return this.ID.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Sample) {
            return 0 == this.compareTo((Sample)o);
        }
        return false;
    }

    final Sample mergeSamples(Sample newSample) {
        if (this.equals(newSample)) {
            return newSample;
        }
        return new Sample(this.getID(), Sample.mergeValues(this.getID(), "FamilyID", this.getFamilyID(), newSample.getFamilyID(), null), Sample.mergeValues(this.getID(), "PaternalID", this.getPaternalID(), newSample.getPaternalID(), null), Sample.mergeValues(this.getID(), "MaterialID", this.getMaternalID(), newSample.getMaternalID(), null), Sample.mergeValues(this.getID(), "Gender", this.getSex(), newSample.getSex(), Sex.UNKNOWN), Sample.mergeValues(this.getID(), "Affection", this.getAffection(), newSample.getAffection(), Affection.UNKNOWN));
    }

    private static <T> T mergeValues(String name, String field, T o1, T o2, T emptyValue) {
        if (o1 == null || o1.equals(emptyValue)) {
            return o2 == null ? null : (T)o2;
        }
        if (o2 == null || o2.equals(emptyValue)) {
            return o1;
        }
        if (o1 instanceof String && o1.equals(o2)) {
            return o1;
        }
        if (o1 == o2) {
            return o1;
        }
        throw new UserException("Inconsistent values detected for " + name + " for field " + field + " value1 " + o1 + " value2 " + o2);
    }
}

