/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.samples;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.utils.samples.PedigreeValidationType;
import org.broadinstitute.hellbender.utils.samples.Sample;
import org.broadinstitute.hellbender.utils.samples.SampleDBBuilder;
import org.broadinstitute.hellbender.utils.samples.Trio;

public final class SampleDB {
    private final Map<String, Sample> samples = new LinkedHashMap<String, Sample>();

    SampleDB() {
    }

    public static SampleDB createSampleDBFromPedigree(GATKPath pedigreeFile, PedigreeValidationType strictness) {
        return SampleDB.createSampleDBFromPedigreeAndDataSources(pedigreeFile, null, strictness);
    }

    public static SampleDB createSampleDBFromPedigree(GATKPath pedigreeFile) {
        return SampleDB.createSampleDBFromPedigree(pedigreeFile, PedigreeValidationType.STRICT);
    }

    public static SampleDB createSampleDBFromPedigreeAndDataSources(GATKPath pedigreeFile, Collection<String> samples, PedigreeValidationType strictness) {
        SampleDBBuilder sampleDBBuilder = new SampleDBBuilder(strictness);
        if (pedigreeFile != null) {
            sampleDBBuilder.addSamplesFromPedigreeFiles(Collections.singletonList(pedigreeFile));
        }
        if (samples != null) {
            sampleDBBuilder.addSamplesFromSampleNames(samples);
        }
        return sampleDBBuilder.getFinalSampleDB();
    }

    protected SampleDB addSample(Sample newSample) {
        Sample updatedSample = newSample;
        Sample prevSample = this.samples.get(newSample.getID());
        if (prevSample != null) {
            updatedSample = prevSample.mergeSamples(newSample);
        }
        this.samples.put(newSample.getID(), updatedSample);
        return this;
    }

    public Sample getSample(String id) {
        return this.samples.get(id);
    }

    public int sampleCount() {
        return this.samples.size();
    }

    public Set<Sample> getSamples() {
        return new LinkedHashSet<Sample>(this.samples.values());
    }

    public final Set<String> getFamilyIDs() {
        return this.getFamilies().keySet();
    }

    public final Map<String, Set<Sample>> getFamilies() {
        return this.getFamilies(null);
    }

    public final Map<String, Set<Sample>> getFamilies(Collection<String> sampleIds) {
        TreeMap<String, Set<Sample>> families = new TreeMap<String, Set<Sample>>();
        for (Sample sample : this.samples.values()) {
            String famID;
            if (sampleIds != null && !sampleIds.contains(sample.getID()) || (famID = sample.getFamilyID()) == null) continue;
            if (!families.containsKey(famID)) {
                families.put(famID, new TreeSet());
            }
            ((Set)families.get(famID)).add(sample);
        }
        return families;
    }

    public Set<Sample> getFamily(String familyId) {
        return this.getFamilies().get(familyId);
    }

    public Set<Trio> getTrios(boolean strictOneChild) {
        Set<Trio> trioSet = new LinkedHashSet<Trio>();
        for (String familyString : this.getFamilyIDs()) {
            Set<Sample> family = this.getFamily(familyString);
            for (Sample sample : family) {
                if (this.getParents(sample).size() != 2) continue;
                Trio trio = new Trio(this.getSample(sample.getMaternalID()), this.getSample(sample.getPaternalID()), sample);
                trioSet.add(trio);
            }
        }
        if (strictOneChild) {
            trioSet = this.removeTriosWithSameParents(trioSet);
        }
        return trioSet;
    }

    public final Set<Trio> getTrios() {
        return this.getTrios(false);
    }

    private Set<Trio> removeTriosWithSameParents(Set<Trio> trios) {
        LinkedHashSet<Trio> filteredTrios = new LinkedHashSet<Trio>();
        filteredTrios.addAll(trios);
        LinkedHashSet<Trio> triosWithSameParents = new LinkedHashSet<Trio>();
        for (Trio referenceTrio : filteredTrios) {
            for (Trio compareTrio : filteredTrios) {
                if (referenceTrio == compareTrio || !referenceTrio.getFather().equals(compareTrio.getFather()) || !referenceTrio.getMother().equals(compareTrio.getMother())) continue;
                triosWithSameParents.add(referenceTrio);
                triosWithSameParents.add(compareTrio);
            }
        }
        filteredTrios.removeAll(triosWithSameParents);
        return filteredTrios;
    }

    public Set<String> getFounderIds() {
        LinkedHashSet<String> founders = new LinkedHashSet<String>();
        for (Sample sample : this.getSamples()) {
            if (this.getParents(sample).size() >= 1) continue;
            founders.add(sample.getID());
        }
        return founders;
    }

    public Sample getMother(Sample offSpring) {
        String maternalID = offSpring.getMaternalID();
        return null == maternalID ? null : this.samples.get(maternalID);
    }

    public Sample getFather(Sample offSpring) {
        String paternalID = offSpring.getPaternalID();
        return null == paternalID ? null : this.samples.get(paternalID);
    }

    public List<Sample> getParents(Sample offSpring) {
        ArrayList<Sample> parents = new ArrayList<Sample>(2);
        Sample parent = this.getMother(offSpring);
        if (parent != null) {
            parents.add(parent);
        }
        if ((parent = this.getFather(offSpring)) != null) {
            parents.add(parent);
        }
        return parents;
    }
}

