/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.samples;

import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.engine.GATKPath;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.samples.PedReader;
import org.broadinstitute.hellbender.utils.samples.PedigreeValidationType;
import org.broadinstitute.hellbender.utils.samples.Sample;
import org.broadinstitute.hellbender.utils.samples.SampleDB;
import org.broadinstitute.hellbender.utils.samples.Sex;

public class SampleDBBuilder {
    private final PedigreeValidationType validationStrictness;
    private final SampleDB sampleDB = new SampleDB();
    private final Set<Sample> samplesFromDataSources = new LinkedHashSet<Sample>();
    private final Set<Sample> samplesFromPedigrees = new LinkedHashSet<Sample>();

    public SampleDBBuilder(PedigreeValidationType validationStrictness) {
        this.validationStrictness = validationStrictness;
    }

    public SampleDBBuilder addSamplesFromPedigreeFiles(List<GATKPath> pedigreeFiles) {
        for (GATKPath pedFile : pedigreeFiles) {
            Collection<Sample> samples = this.addSamplesFromPedigreeArgument(pedFile);
            this.samplesFromPedigrees.addAll(samples);
        }
        return this;
    }

    public SampleDBBuilder addSamplesFromPedigreeStrings(List<String> pedigreeStrings) {
        for (String pedString : pedigreeStrings) {
            Collection<Sample> samples = this.addSamplesFromPedigreeArgument(pedString);
            this.samplesFromPedigrees.addAll(samples);
        }
        return this;
    }

    /*
     * Exception decompiling
     */
    private Collection<Sample> addSamplesFromPedigreeArgument(GATKPath sampleFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SampleDBBuilder addSamplesFromSampleNames(Collection<String> sampleNames) {
        Utils.nonNull(sampleNames);
        for (String sampleName : sampleNames) {
            if (this.sampleDB.getSample(sampleName) != null) continue;
            Sample newSample = new Sample(sampleName, null, null, null, Sex.UNKNOWN);
            this.sampleDB.addSample(newSample);
            this.samplesFromDataSources.add(newSample);
        }
        return this;
    }

    private Collection<Sample> addSamplesFromPedigreeArgument(String string) {
        PedReader reader = new PedReader();
        return reader.parse(string, this.getMissingFields(string), this.sampleDB);
    }

    public SampleDB getFinalSampleDB() {
        this.validate();
        return this.sampleDB;
    }

    private EnumSet<PedReader.MissingPedField> getMissingFields(Object engineArg) {
        return EnumSet.noneOf(PedReader.MissingPedField.class);
    }

    private void validate() {
        this.validatePedigreeIDUniqueness();
        if (this.validationStrictness != PedigreeValidationType.SILENT && !this.samplesFromPedigrees.isEmpty() && !this.samplesFromDataSources.isEmpty()) {
            Set sampleNamesFromPedigrees = this.samplesFromPedigrees.stream().map(Sample::getID).collect(Collectors.toSet());
            for (Sample dsSample : this.samplesFromDataSources) {
                if (sampleNamesFromPedigrees.contains(dsSample.getID())) continue;
                throw new UserException("Sample " + dsSample.getID() + " found in data sources but not in pedigree files with STRICT pedigree validation");
            }
        }
    }

    private void validatePedigreeIDUniqueness() {
        Set pedigreeIDs = this.samplesFromPedigrees.stream().map(Sample::getID).collect(Collectors.toSet());
        assert (pedigreeIDs.size() == this.samplesFromPedigrees.size()) : "The number of sample IDs extracted from the pedigree does not equal the number of samples in the pedigree. Is a sample associated with multiple families?";
    }
}

