/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.samples;

import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.samples.Sample;

public final class Trio {
    private final Sample mother;
    private final Sample father;
    private final Sample child;

    public Trio(Sample mom, Sample dad, Sample child) {
        Utils.nonNull(mom, "mom is null");
        Utils.nonNull(dad, "dad is null");
        Utils.nonNull(child, "child is null");
        if (!mom.getID().equals(child.getMaternalID())) {
            throw new IllegalArgumentException("incorrect mother");
        }
        if (!dad.getID().equals(child.getPaternalID())) {
            throw new IllegalArgumentException("incorrect father");
        }
        this.mother = mom;
        this.father = dad;
        this.child = child;
    }

    public Sample getMother() {
        return this.mother;
    }

    public String getMaternalID() {
        return this.mother.getID();
    }

    public Sample getFather() {
        return this.father;
    }

    public String getPaternalID() {
        return this.father.getID();
    }

    public Sample getChild() {
        return this.child;
    }

    public String getChildID() {
        return this.child.getID();
    }
}

