/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.smithwaterman;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.TextCigarCodec;
import java.util.Collections;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWAlignerNativeBinding;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWNativeAlignerResult;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWOverhangStrategy;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWParameters;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.smithwaterman.SmithWatermanAligner;
import org.broadinstitute.hellbender.utils.smithwaterman.SmithWatermanAlignment;

public final class SWNativeAlignerWrapper
implements SmithWatermanAligner {
    private final SWAlignerNativeBinding aligner;
    private long totalComputeTime = 0L;

    public SWNativeAlignerWrapper(SWAlignerNativeBinding aligner) {
        this.aligner = aligner;
    }

    @Override
    public SmithWatermanAlignment align(byte[] reference, byte[] alternate, SWParameters parameters, SWOverhangStrategy overhangStrategy) {
        SWNativeResultWrapper alignmentResult;
        long startTime = System.nanoTime();
        Utils.nonNull(parameters);
        Utils.nonNull(overhangStrategy);
        int matchIndex = -1;
        if (overhangStrategy == SWOverhangStrategy.SOFTCLIP || overhangStrategy == SWOverhangStrategy.IGNORE) {
            matchIndex = Utils.lastIndexOf(reference, alternate);
        }
        if (matchIndex != -1) {
            alignmentResult = new SWNativeResultWrapper(new Cigar(Collections.singletonList(new CigarElement(alternate.length, CigarOperator.M))), matchIndex);
        } else {
            SWNativeAlignerResult alignment = this.aligner.align(reference, alternate, parameters, overhangStrategy);
            alignmentResult = new SWNativeResultWrapper(alignment);
        }
        this.totalComputeTime += System.nanoTime() - startTime;
        return alignmentResult;
    }

    @Override
    public void close() {
        logger.info(String.format("Total compute time in native Smith-Waterman : %.2f sec", (double)this.totalComputeTime * 1.0E-9));
        this.aligner.close();
    }

    private static final class SWNativeResultWrapper
    implements SmithWatermanAlignment {
        private final Cigar cigar;
        private final int alignmentOffset;

        public SWNativeResultWrapper(SWNativeAlignerResult nativeResult) {
            this.cigar = TextCigarCodec.decode((String)nativeResult.cigar);
            this.alignmentOffset = nativeResult.alignment_offset;
        }

        public SWNativeResultWrapper(Cigar cigar, int alignmentOffset) {
            this.cigar = cigar;
            this.alignmentOffset = alignmentOffset;
        }

        @Override
        public Cigar getCigar() {
            return this.cigar;
        }

        @Override
        public int getAlignmentOffset() {
            return this.alignmentOffset;
        }
    }
}

