/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.smithwaterman;

import java.io.Closeable;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWOverhangStrategy;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWParameters;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.smithwaterman.SmithWatermanAlignment;
import org.broadinstitute.hellbender.utils.smithwaterman.SmithWatermanIntelAligner;
import org.broadinstitute.hellbender.utils.smithwaterman.SmithWatermanJavaAligner;

public interface SmithWatermanAligner
extends Closeable {
    public static final Logger logger = LogManager.getLogger(SmithWatermanAligner.class);
    public static final SWParameters ORIGINAL_DEFAULT = new SWParameters(3, -1, -4, -3);
    public static final SWParameters STANDARD_NGS = new SWParameters(25, -50, -110, -6);

    public SmithWatermanAlignment align(byte[] var1, byte[] var2, SWParameters var3, SWOverhangStrategy var4);

    @Override
    default public void close() {
    }

    public static SmithWatermanAligner getAligner(Implementation type) {
        return type.createAligner();
    }

    public static enum Implementation {
        FASTEST_AVAILABLE(() -> {
            try {
                SmithWatermanIntelAligner aligner = new SmithWatermanIntelAligner();
                logger.info("Using AVX accelerated SmithWaterman implementation");
                return aligner;
            }
            catch (UserException.HardwareFeatureException exception) {
                logger.info("AVX accelerated SmithWaterman implementation is not supported, falling back to the Java implementation");
                return SmithWatermanJavaAligner.getInstance();
            }
        }),
        AVX_ENABLED(() -> {
            SmithWatermanIntelAligner aligner = new SmithWatermanIntelAligner();
            logger.info("Using AVX accelerated SmithWaterman implementation");
            return aligner;
        }),
        JAVA(SmithWatermanJavaAligner::getInstance);

        private final Supplier<SmithWatermanAligner> alignerSupplier;

        private Implementation(Supplier<SmithWatermanAligner> alignerSupplier) {
            this.alignerSupplier = alignerSupplier;
        }

        private SmithWatermanAligner createAligner() {
            return this.alignerSupplier.get();
        }
    }
}

