/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.smithwaterman;

import com.google.common.collect.Lists;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWOverhangStrategy;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWParameters;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.smithwaterman.SmithWatermanAligner;
import org.broadinstitute.hellbender.utils.smithwaterman.SmithWatermanAlignment;

public final class SmithWatermanJavaAligner
implements SmithWatermanAligner {
    private static final SmithWatermanJavaAligner ALIGNER = new SmithWatermanJavaAligner();
    private long totalComputeTime = 0L;

    public static SmithWatermanJavaAligner getInstance() {
        return ALIGNER;
    }

    private SmithWatermanJavaAligner() {
    }

    @Override
    public SmithWatermanAlignment align(byte[] reference, byte[] alternate, SWParameters parameters, SWOverhangStrategy overhangStrategy) {
        SWPairwiseAlignmentResult alignmentResult;
        long startTime = System.nanoTime();
        new String(reference);
        if (reference == null || reference.length == 0 || alternate == null || alternate.length == 0) {
            throw new IllegalArgumentException("Non-null, non-empty sequences are required for the Smith-Waterman calculation");
        }
        Utils.nonNull(parameters);
        Utils.nonNull(overhangStrategy);
        int matchIndex = -1;
        if (overhangStrategy == SWOverhangStrategy.SOFTCLIP || overhangStrategy == SWOverhangStrategy.IGNORE) {
            matchIndex = Utils.lastIndexOf(reference, alternate);
        }
        if (matchIndex != -1) {
            alignmentResult = new SWPairwiseAlignmentResult(new Cigar(Collections.singletonList(new CigarElement(alternate.length, CigarOperator.M))), matchIndex);
        } else {
            int n = reference.length + 1;
            int m = alternate.length + 1;
            int[][] sw = new int[n][m];
            int[][] btrack = new int[n][m];
            SmithWatermanJavaAligner.calculateMatrix(reference, alternate, sw, btrack, overhangStrategy, parameters);
            alignmentResult = SmithWatermanJavaAligner.calculateCigar(sw, btrack, overhangStrategy);
        }
        this.totalComputeTime += System.nanoTime() - startTime;
        return alignmentResult;
    }

    private static void calculateMatrix(byte[] reference, byte[] alternate, int[][] sw, int[][] btrack, SWOverhangStrategy overhangStrategy, SWParameters parameters) {
        if (reference.length == 0 || alternate.length == 0) {
            throw new IllegalArgumentException("Non-null, non-empty sequences are required for the Smith-Waterman calculation");
        }
        int ncol = sw[0].length;
        int nrow = sw.length;
        int MATRIX_MIN_CUTOFF = -100000000;
        int lowInitValue = -1073741824;
        int[] best_gap_v = new int[ncol + 1];
        Arrays.fill(best_gap_v, -1073741824);
        int[] gap_size_v = new int[ncol + 1];
        int[] best_gap_h = new int[nrow + 1];
        Arrays.fill(best_gap_h, -1073741824);
        int[] gap_size_h = new int[nrow + 1];
        if (overhangStrategy == SWOverhangStrategy.INDEL || overhangStrategy == SWOverhangStrategy.LEADING_INDEL) {
            int i;
            int[] topRow = sw[0];
            topRow[1] = parameters.getGapOpenPenalty();
            int currentValue = parameters.getGapOpenPenalty();
            for (i = 2; i < topRow.length; ++i) {
                topRow[i] = currentValue += parameters.getGapExtendPenalty();
            }
            sw[1][0] = parameters.getGapOpenPenalty();
            currentValue = parameters.getGapOpenPenalty();
            for (i = 2; i < sw.length; ++i) {
                sw[i][0] = currentValue += parameters.getGapExtendPenalty();
            }
        }
        int[] curRow = sw[0];
        int w_open = parameters.getGapOpenPenalty();
        int w_extend = parameters.getGapExtendPenalty();
        int w_match = parameters.getMatchValue();
        int w_mismatch = parameters.getMismatchPenalty();
        int sw_length = sw.length;
        for (int i = 1; i < sw_length; ++i) {
            byte a_base = reference[i - 1];
            int[] lastRow = curRow;
            curRow = sw[i];
            int[] curBackTrackRow = btrack[i];
            int curRow_length = curRow.length;
            for (int j = 1; j < curRow_length; ++j) {
                boolean diagHighestOrEqual;
                byte b_base = alternate[j - 1];
                int step_diag = lastRow[j - 1] + (a_base == b_base ? w_match : w_mismatch);
                int prev_gap = lastRow[j] + w_open;
                int n = j;
                best_gap_v[n] = best_gap_v[n] + w_extend;
                if (prev_gap > best_gap_v[j]) {
                    best_gap_v[j] = prev_gap;
                    gap_size_v[j] = 1;
                } else {
                    int n2 = j;
                    gap_size_v[n2] = gap_size_v[n2] + 1;
                }
                int step_down = best_gap_v[j];
                int kd = gap_size_v[j];
                prev_gap = curRow[j - 1] + w_open;
                int n3 = i;
                best_gap_h[n3] = best_gap_h[n3] + w_extend;
                if (prev_gap > best_gap_h[i]) {
                    best_gap_h[i] = prev_gap;
                    gap_size_h[i] = 1;
                } else {
                    int n4 = i;
                    gap_size_h[n4] = gap_size_h[n4] + 1;
                }
                int step_right = best_gap_h[i];
                int ki = gap_size_h[i];
                boolean bl = diagHighestOrEqual = step_diag >= step_down && step_diag >= step_right;
                if (diagHighestOrEqual) {
                    curRow[j] = Math.max(-100000000, step_diag);
                    curBackTrackRow[j] = 0;
                    continue;
                }
                if (step_right >= step_down) {
                    curRow[j] = Math.max(-100000000, step_right);
                    curBackTrackRow[j] = -ki;
                    continue;
                }
                curRow[j] = Math.max(-100000000, step_down);
                curBackTrackRow[j] = kd;
            }
        }
    }

    private static SWPairwiseAlignmentResult calculateCigar(int[][] sw, int[][] btrack, SWOverhangStrategy overhangStrategy) {
        int alignment_offset;
        int p1 = 0;
        int p2 = 0;
        int refLength = sw.length - 1;
        int altLength = sw[0].length - 1;
        int maxscore = Integer.MIN_VALUE;
        int segment_length = 0;
        if (overhangStrategy == SWOverhangStrategy.INDEL) {
            p1 = refLength;
            p2 = altLength;
        } else {
            p2 = altLength;
            for (int i = 1; i < sw.length; ++i) {
                int curScore = sw[i][altLength];
                if (curScore < maxscore) continue;
                p1 = i;
                maxscore = curScore;
            }
            if (overhangStrategy != SWOverhangStrategy.LEADING_INDEL) {
                int[] bottomRow = sw[refLength];
                for (int j = 1; j < bottomRow.length; ++j) {
                    int curScore = bottomRow[j];
                    if (curScore <= maxscore && (curScore != maxscore || Math.abs(refLength - j) >= Math.abs(p1 - p2))) continue;
                    p1 = refLength;
                    p2 = j;
                    maxscore = curScore;
                    segment_length = altLength - j;
                }
            }
        }
        ArrayList<CigarElement> lce = new ArrayList<CigarElement>(5);
        if (segment_length > 0 && overhangStrategy == SWOverhangStrategy.SOFTCLIP) {
            lce.add(SmithWatermanJavaAligner.makeElement(State.CLIP, segment_length));
            segment_length = 0;
        }
        State state = State.MATCH;
        do {
            State new_state;
            int btr = btrack[p1][p2];
            int step_length = 1;
            if (btr > 0) {
                new_state = State.DELETION;
                step_length = btr;
            } else if (btr < 0) {
                new_state = State.INSERTION;
                step_length = -btr;
            } else {
                new_state = State.MATCH;
            }
            switch (new_state) {
                case MATCH: {
                    --p1;
                    --p2;
                    break;
                }
                case INSERTION: {
                    p2 -= step_length;
                    break;
                }
                case DELETION: {
                    p1 -= step_length;
                }
            }
            if (new_state == state) {
                segment_length += step_length;
                continue;
            }
            if (segment_length > 0) {
                lce.add(SmithWatermanJavaAligner.makeElement(state, segment_length));
            }
            segment_length = step_length;
            state = new_state;
        } while (p1 > 0 && p2 > 0);
        if (overhangStrategy == SWOverhangStrategy.SOFTCLIP) {
            lce.add(SmithWatermanJavaAligner.makeElement(state, segment_length));
            if (p2 > 0) {
                lce.add(SmithWatermanJavaAligner.makeElement(State.CLIP, p2));
            }
            alignment_offset = p1;
        } else if (overhangStrategy == SWOverhangStrategy.IGNORE) {
            lce.add(SmithWatermanJavaAligner.makeElement(state, segment_length + p2));
            alignment_offset = p1 - p2;
        } else {
            lce.add(SmithWatermanJavaAligner.makeElement(state, segment_length));
            if (p1 > 0) {
                lce.add(SmithWatermanJavaAligner.makeElement(State.DELETION, p1));
            } else if (p2 > 0) {
                lce.add(SmithWatermanJavaAligner.makeElement(State.INSERTION, p2));
            }
            alignment_offset = 0;
        }
        return new SWPairwiseAlignmentResult(new Cigar(Lists.reverse(lce)), alignment_offset);
    }

    private static CigarElement makeElement(State state, int length) {
        CigarOperator op = null;
        switch (state) {
            case MATCH: {
                op = CigarOperator.M;
                break;
            }
            case INSERTION: {
                op = CigarOperator.I;
                break;
            }
            case DELETION: {
                op = CigarOperator.D;
                break;
            }
            case CLIP: {
                op = CigarOperator.S;
            }
        }
        return new CigarElement(length, op);
    }

    @Override
    public void close() {
        logger.info(String.format("Total compute time in java Smith-Waterman : %.2f sec", (double)this.totalComputeTime * 1.0E-9));
    }

    private static final class SWPairwiseAlignmentResult
    implements SmithWatermanAlignment {
        private final Cigar cigar;
        private final int alignmentOffset;

        SWPairwiseAlignmentResult(Cigar cigar, int alignmentOffset) {
            this.cigar = cigar;
            this.alignmentOffset = alignmentOffset;
        }

        @Override
        public Cigar getCigar() {
            return this.cigar;
        }

        @Override
        public int getAlignmentOffset() {
            return this.alignmentOffset;
        }
    }

    protected static enum State {
        MATCH,
        INSERTION,
        DELETION,
        CLIP;

    }
}

