/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.solver;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import org.apache.commons.math3.analysis.solvers.BrentSolver;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.util.FastMath;
import org.broadinstitute.hellbender.utils.Utils;

public final class RobustBrentSolver
extends AbstractUnivariateSolver {
    private final UnivariateFunction meritFunc;
    private final int numBisections;
    private final int depth;

    public RobustBrentSolver(double relativeAccuracy, double absoluteAccuracy, double functionValueAccuracy, @Nullable UnivariateFunction meritFunc, int numBisections, int depth) {
        super(relativeAccuracy, absoluteAccuracy, functionValueAccuracy);
        this.meritFunc = meritFunc;
        this.numBisections = numBisections;
        this.depth = depth;
    }

    public double solve(int maxEval, UnivariateFunction objFunc, double min, double max) throws TooManyEvaluationsException, NoBracketingException {
        this.setup(maxEval, objFunc, min, max, min);
        return this.doSolve();
    }

    protected double doSolve() throws TooManyEvaluationsException, NoBracketingException {
        double[] fSearchGrid;
        double max;
        double min = this.getMin();
        double[] xSearchGrid = this.createHybridSearchGrid(min, max = this.getMax(), this.numBisections, this.depth);
        List<Bracket> bracketsList = RobustBrentSolver.detectBrackets(xSearchGrid, fSearchGrid = Arrays.stream(xSearchGrid).map(arg_0 -> ((RobustBrentSolver)this).computeObjectiveValue(arg_0)).toArray());
        if (bracketsList.isEmpty()) {
            throw new NoBracketingException(min, max, fSearchGrid[0], fSearchGrid[fSearchGrid.length - 1]);
        }
        BrentSolver solver = new BrentSolver(this.getRelativeAccuracy(), this.getAbsoluteAccuracy(), this.getFunctionValueAccuracy());
        List roots = bracketsList.stream().map(b -> solver.solve(this.getMaxEvaluations(), arg_0 -> ((RobustBrentSolver)this).computeObjectiveValue(arg_0), b.min, b.max, 0.5 * (b.min + b.max))).collect(Collectors.toList());
        if (roots.size() == 1 || this.meritFunc == null) {
            return (Double)roots.get(0);
        }
        double[] merits = roots.stream().mapToDouble(arg_0 -> ((UnivariateFunction)this.meritFunc).value(arg_0)).toArray();
        int bestRootIndex = IntStream.range(0, roots.size()).boxed().max((i, j) -> (int)(merits[i] - merits[j])).get();
        return (Double)roots.get(bestRootIndex);
    }

    @VisibleForTesting
    double[] createHybridSearchGrid(double min, double max, int logSubdivisions, int uniformSubdivisions) {
        double[] baseGrid = this.createLogarithmicGrid(min, max, logSubdivisions, 2.0);
        int nBaseGrid = logSubdivisions + 2;
        if (uniformSubdivisions > 1) {
            double[] refinedGrid = new double[(nBaseGrid - 1) * uniformSubdivisions + 1];
            for (int j = 0; j < nBaseGrid - 1; ++j) {
                double len = (baseGrid[j + 1] - baseGrid[j]) / (double)uniformSubdivisions;
                for (int k = 0; k < uniformSubdivisions; ++k) {
                    refinedGrid[j * uniformSubdivisions + k] = baseGrid[j] + (double)k * len;
                }
            }
            refinedGrid[(nBaseGrid - 1) * uniformSubdivisions] = max;
            return refinedGrid;
        }
        return baseGrid;
    }

    private double[] createLogarithmicGrid(double min, double max, int subdivisions, double base) {
        int j;
        Utils.validateArg(base > 1.0, "The logarithm base must be greater than 1");
        double[] grid = new double[subdivisions + 2];
        grid[0] = 0.0;
        grid[subdivisions + 1] = max - min;
        for (j = subdivisions; j > 0; --j) {
            grid[j] = grid[j + 1] / base;
        }
        j = 0;
        while (j < subdivisions + 2) {
            int n = j++;
            grid[n] = grid[n] + min;
        }
        return grid;
    }

    @VisibleForTesting
    static List<Bracket> detectBrackets(double[] x, double[] f) {
        ArrayList<Bracket> brackets = new ArrayList<Bracket>();
        double[] signs = new double[f.length];
        for (int i = 0; i < f.length; ++i) {
            signs[i] = FastMath.signum((double)f[i]);
        }
        double prevSignum = signs[0];
        int prevIdx = 0;
        for (int idx = 1; idx < f.length; ++idx) {
            if (!(signs[idx] * prevSignum <= 0.0)) continue;
            brackets.add(new Bracket(x[prevIdx], x[idx]));
            prevIdx = idx;
            prevSignum = signs[idx];
        }
        return brackets;
    }

    @VisibleForTesting
    static final class Bracket {
        final double min;
        final double max;

        Bracket(double min, double max) {
            this.min = min;
            this.max = max;
        }
    }
}

