/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.solver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.util.FastMath;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.param.ParamUtils;
import org.broadinstitute.hellbender.utils.solver.UnivariateSolverJobDescription;
import org.broadinstitute.hellbender.utils.solver.UnivariateSolverSpecifications;

public final class SynchronizedUnivariateSolver {
    private static final double DEFAULT_FUNCTION_ACCURACY = 1.0E-15;
    private final ConcurrentHashMap<Integer, Double> queries;
    private final ConcurrentHashMap<Integer, Double> results;
    private final int numberOfQueriesBeforeCalling;
    private final Function<Map<Integer, Double>, Map<Integer, Double>> func;
    private final List<UnivariateSolverJobDescription> jobDescriptions;
    private final List<UnivariateSolverSpecifications> solverDescriptions;
    private final Function<UnivariateSolverSpecifications, AbstractUnivariateSolver> solverFactory;
    private final Set<Integer> jobIndices;
    private final Lock resultsLock = new ReentrantLock();
    private final Condition resultsAvailable = this.resultsLock.newCondition();
    private CountDownLatch solversCountDownLatch;

    public SynchronizedUnivariateSolver(Function<Map<Integer, Double>, Map<Integer, Double>> func, Function<UnivariateSolverSpecifications, AbstractUnivariateSolver> solverFactory, int numberOfQueriesBeforeCalling) {
        this.func = Utils.nonNull(func);
        this.solverFactory = Utils.nonNull(solverFactory);
        this.numberOfQueriesBeforeCalling = ParamUtils.isPositive(numberOfQueriesBeforeCalling, "Number of queries before calling function evaluations must be positive");
        this.queries = new ConcurrentHashMap(numberOfQueriesBeforeCalling);
        this.results = new ConcurrentHashMap(numberOfQueriesBeforeCalling);
        this.jobDescriptions = new ArrayList<UnivariateSolverJobDescription>();
        this.solverDescriptions = new ArrayList<UnivariateSolverSpecifications>();
        this.jobIndices = new HashSet<Integer>();
    }

    public void add(int index, double min, double max, double x0, double absoluteAccuracy, double relativeAccuracy, double functionValueAccuracy, int maxEval) {
        if (this.jobIndices.contains(index)) {
            throw new IllegalArgumentException("A jobDescription with index " + index + " already exists; jobDescription indices must be unique");
        }
        if (x0 <= min || x0 >= max) {
            throw new IllegalArgumentException(String.format("The initial guess \"%f\" for equation number \"%d\" is must lie inside the provided search bracket [%f, %f]", x0, index, min, max));
        }
        this.jobDescriptions.add(new UnivariateSolverJobDescription(index, min, max, x0, maxEval));
        this.solverDescriptions.add(new UnivariateSolverSpecifications(absoluteAccuracy, relativeAccuracy, functionValueAccuracy));
    }

    public void add(int index, double min, double max, double x0, double absoluteAccuracy, double relativeAccuracy, int maxEval) {
        this.add(index, min, max, x0, absoluteAccuracy, relativeAccuracy, 1.0E-15, maxEval);
    }

    public Map<Integer, UnivariateSolverSummary> solve() throws InterruptedException {
        if (this.jobDescriptions.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap solvers = new HashMap(this.jobDescriptions.size());
        this.solversCountDownLatch = new CountDownLatch(this.jobDescriptions.size());
        IntStream.range(0, this.jobDescriptions.size()).forEach(jobIdx -> solvers.put(this.jobDescriptions.get(jobIdx).getIndex(), new SolverWorker(this.solverDescriptions.get(jobIdx), this.jobDescriptions.get(jobIdx))));
        solvers.values().forEach(worker -> new Thread((Runnable)worker).start());
        this.solversCountDownLatch.await();
        return solvers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((SolverWorker)entry.getValue()).getSummary()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double evaluate(int index, double x) throws InterruptedException {
        double value;
        this.queries.put(index, x);
        this.resultsLock.lock();
        try {
            this.fetchResults();
            while (!this.results.containsKey(index)) {
                this.resultsAvailable.await();
            }
            value = this.results.get(index);
            this.results.remove(index);
        }
        finally {
            this.resultsLock.unlock();
        }
        return value;
    }

    private void fetchResults() {
        this.resultsLock.lock();
        try {
            if ((long)this.queries.size() >= FastMath.min((long)this.numberOfQueriesBeforeCalling, (long)this.solversCountDownLatch.getCount())) {
                this.results.putAll(this.func.apply(this.queries));
                this.queries.clear();
                this.resultsAvailable.signalAll();
            }
        }
        finally {
            this.resultsLock.unlock();
        }
    }

    private final class SolverWorker
    implements Runnable {
        final UnivariateSolverJobDescription jobDescription;
        final UnivariateSolverSpecifications solverDescription;
        UnivariateSolverStatus status;
        private UnivariateSolverSummary summary;

        SolverWorker(UnivariateSolverSpecifications solverDescription, UnivariateSolverJobDescription jobDescription) {
            this.solverDescription = solverDescription;
            this.jobDescription = jobDescription;
            this.status = UnivariateSolverStatus.TBD;
        }

        @Override
        public void run() {
            double sol;
            AbstractUnivariateSolver abstractSolver = (AbstractUnivariateSolver)SynchronizedUnivariateSolver.this.solverFactory.apply(this.solverDescription);
            try {
                sol = abstractSolver.solve(this.jobDescription.getMaxEvaluations(), x -> {
                    double value;
                    try {
                        value = SynchronizedUnivariateSolver.this.evaluate(this.jobDescription.getIndex(), x);
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException(String.format("Evaluation of equation (n=%d) was interrupted -- can not continue", this.jobDescription.getIndex()));
                    }
                    return value;
                }, this.jobDescription.getMin(), this.jobDescription.getMax(), this.jobDescription.getInitialGuess());
                this.status = UnivariateSolverStatus.SUCCESS;
            }
            catch (NoBracketingException ex) {
                this.status = UnivariateSolverStatus.NO_BRACKETING;
                sol = Double.NaN;
            }
            catch (TooManyEvaluationsException ex) {
                this.status = UnivariateSolverStatus.TOO_MANY_EVALUATIONS;
                sol = Double.NaN;
            }
            this.summary = new UnivariateSolverSummary(sol, abstractSolver.getEvaluations(), this.status);
            SynchronizedUnivariateSolver.this.solversCountDownLatch.countDown();
            SynchronizedUnivariateSolver.this.fetchResults();
        }

        UnivariateSolverSummary getSummary() {
            return Utils.nonNull(this.summary, "Solver summary is not available");
        }
    }

    public final class UnivariateSolverSummary {
        public final double x;
        public final int evaluations;
        public final UnivariateSolverStatus status;

        UnivariateSolverSummary(double x, int evaluations, UnivariateSolverStatus status) {
            this.x = x;
            this.evaluations = evaluations;
            this.status = status;
        }
    }

    public static enum UnivariateSolverStatus {
        NO_BRACKETING,
        TOO_MANY_EVALUATIONS,
        SUCCESS,
        TBD;

    }
}

