/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.spark;

import com.google.common.collect.Iterators;
import htsjdk.variant.variantcontext.VariantContext;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.SparkFiles;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.broadinstitute.hellbender.engine.FeatureDataSource;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.collections.AutoCloseableCollection;
import org.broadinstitute.hellbender.utils.config.ConfigFactory;
import org.broadinstitute.hellbender.utils.iterators.CloseAtEndIterator;
import org.broadinstitute.hellbender.utils.read.GATKRead;
import org.broadinstitute.hellbender.utils.variant.GATKVariant;
import org.broadinstitute.hellbender.utils.variant.VariantContextVariantAdapter;
import scala.Tuple2;

public final class JoinReadsWithVariants {
    private static final int DEFAULT_QUERY_LOOKAHEAD_BASES = 100000;

    private JoinReadsWithVariants() {
    }

    public static JavaPairRDD<GATKRead, Iterable<GATKVariant>> join(JavaRDD<GATKRead> reads, List<String> variantsFileNames) {
        return reads.mapPartitionsToPair((PairFlatMapFunction & Serializable)gatkReadIterator -> {
            List variantSources = variantsFileNames.stream().map(fileName -> JoinReadsWithVariants.openFeatureSource(SparkFiles.get((String)fileName))).collect(Collectors.toList());
            Iterator iterator = Iterators.transform((Iterator)gatkReadIterator, read -> JoinReadsWithVariants.getVariantsOverlappingRead(read, variantSources));
            return new CloseAtEndIterator(iterator, new AutoCloseableCollection(variantSources));
        });
    }

    private static Tuple2<GATKRead, Iterable<GATKVariant>> getVariantsOverlappingRead(GATKRead read, List<FeatureDataSource<VariantContext>> variantSources) {
        if (SimpleInterval.isValid(read.getContig(), read.getStart(), read.getEnd())) {
            return new Tuple2((Object)read, JoinReadsWithVariants.getVariantsOverlappingInterval(variantSources, new SimpleInterval(read)));
        }
        return new Tuple2((Object)read, Collections.emptyList());
    }

    private static FeatureDataSource<VariantContext> openFeatureSource(String path) {
        int cloudPrefetchBuffer = ConfigFactory.getInstance().getGATKConfig().cloudPrefetchBuffer();
        int cloudIndexPrefetchBuffer = ConfigFactory.getInstance().getGATKConfig().cloudIndexPrefetchBuffer();
        return new FeatureDataSource<VariantContext>(path, null, 100000, null, cloudPrefetchBuffer, cloudIndexPrefetchBuffer);
    }

    private static List<GATKVariant> getVariantsOverlappingInterval(FeatureDataSource<VariantContext> variantSource, SimpleInterval interval) {
        return Utils.stream(variantSource.query(interval)).map(VariantContextVariantAdapter::sparkVariantAdapter).collect(Collectors.toList());
    }

    private static List<GATKVariant> getVariantsOverlappingInterval(List<FeatureDataSource<VariantContext>> variantSources, SimpleInterval interval) {
        return variantSources.stream().map(variantSource -> JoinReadsWithVariants.getVariantsOverlappingInterval(variantSource, interval)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

