/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.spark;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.broadinstitute.hellbender.utils.Utils;

public final class SparkConverter {
    private static final Logger logger = LogManager.getLogger(SparkConverter.class);

    private SparkConverter() {
    }

    public static RowMatrix convertRealMatrixToSparkRowMatrix(JavaSparkContext sc, RealMatrix realMat, int numSlices) {
        logger.info("Converting matrix to distributed Spark matrix...");
        double[][] dataArray = realMat.getData();
        LinkedList<Vector> rowsList = new LinkedList<Vector>();
        for (double[] i : dataArray) {
            Vector currentRow = Vectors.dense((double[])i);
            rowsList.add(currentRow);
        }
        JavaRDD rows = sc.parallelize(rowsList, numSlices);
        RowMatrix mat = new RowMatrix(rows.rdd());
        logger.info("Done converting matrix to distributed Spark matrix...");
        return mat;
    }

    public static RealMatrix convertSparkMatrixToRealMatrix(Matrix r) {
        Array2DRowRealMatrix result = new Array2DRowRealMatrix(r.numRows(), r.numCols());
        double[] columnMajorMat = r.toArray();
        for (int i = 0; i < r.numRows(); ++i) {
            result.setRow(i, Arrays.copyOfRange(columnMajorMat, i * r.numCols(), i * r.numCols() + r.numCols()));
        }
        return result;
    }

    public static RealMatrix convertSparkRowMatrixToRealMatrix(RowMatrix r, int cachedNumRows) {
        Utils.nonNull(r, "Input row matrix cannot be null");
        int numRows = cachedNumRows == -1 ? (int)r.numRows() : cachedNumRows;
        int numCols = (int)r.numCols();
        Vector[] rowVectors = (Vector[])r.rows().collect();
        Array2DRowRealMatrix result = new Array2DRowRealMatrix(numRows, numCols);
        for (int i = 0; i < numRows; ++i) {
            result.setRow(i, rowVectors[i].toArray());
        }
        return result;
    }
}

