/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.svd;

import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.svd.SVD;
import org.broadinstitute.hellbender.utils.svd.SimpleSVD;
import org.broadinstitute.hellbender.utils.svd.SingularValueDecomposer;

public final class ApacheSingularValueDecomposer
implements SingularValueDecomposer {
    @Override
    public SVD createSVD(RealMatrix m) {
        Utils.nonNull(m, "Cannot create SVD on a null matrix.");
        SingularValueDecomposition svd = new SingularValueDecomposition(m);
        RealMatrix pinv = svd.getSolver().getInverse();
        return new SimpleSVD(svd.getU(), svd.getSingularValues(), svd.getV(), pinv);
    }
}

