/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.svd;

import org.apache.commons.math3.linear.RealMatrix;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.svd.SVD;
import org.broadinstitute.hellbender.utils.svd.SimpleSVD;
import org.broadinstitute.hellbender.utils.svd.SingularValueDecomposer;
import org.ojalgo.access.Access2D;
import org.ojalgo.commons.math3.linear.Access2DWrapper;
import org.ojalgo.commons.math3.linear.RealMatrixWrapper;
import org.ojalgo.matrix.decomposition.SingularValue;

public final class OjAlgoSingularValueDecomposer
implements SingularValueDecomposer {
    private static final Logger logger = LogManager.getLogger(OjAlgoSingularValueDecomposer.class);

    @Override
    public SVD createSVD(RealMatrix m) {
        Utils.nonNull(m, "Cannot create SVD on a null matrix.");
        logger.info("Converting Apache RealMatrix to ojAlgo Matrix...");
        RealMatrixWrapper pds = RealMatrixWrapper.of((RealMatrix)m);
        logger.info("Calculating SVD...");
        SingularValue svd = SingularValue.make((Access2D)pds);
        svd.compute((Access2D.Collectable)pds);
        logger.info("Converting ojAlgo Matrix to Apache RealMatrix...");
        Access2DWrapper pinv = Access2DWrapper.of((Access2D)svd.getInverse());
        Access2DWrapper u = Access2DWrapper.of((Access2D)svd.getQ1());
        Access2DWrapper v = Access2DWrapper.of((Access2D)svd.getQ2());
        double[] s = svd.getSingularValues().toRawCopy1D();
        return new SimpleSVD((RealMatrix)u, s, (RealMatrix)v, (RealMatrix)pinv);
    }
}

