/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.svd;

import org.apache.commons.math3.linear.RealMatrix;
import org.apache.spark.api.java.JavaSparkContext;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.svd.OjAlgoSingularValueDecomposer;
import org.broadinstitute.hellbender.utils.svd.SVD;
import org.broadinstitute.hellbender.utils.svd.SparkSingularValueDecomposer;

public final class SVDFactory {
    public static SVD createSVD(RealMatrix m) {
        Utils.nonNull(m, "Cannot perform SVD on a null.");
        return SVDFactory.createSVD(m, null);
    }

    public static SVD createSVD(RealMatrix m, JavaSparkContext ctx) {
        Utils.nonNull(m, "Cannot create SVD from a null matrix.");
        if (ctx == null) {
            return new OjAlgoSingularValueDecomposer().createSVD(m);
        }
        return new SparkSingularValueDecomposer(ctx).createSVD(m);
    }
}

