/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.text;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.hellbender.exceptions.GATKException;

public final class TextFormattingUtils {
    private TextFormattingUtils() {
    }

    public static List<Integer> getWordStarts(String line) {
        if (line == null) {
            throw new GATKException("line is null");
        }
        ArrayList<Integer> starts = new ArrayList<Integer>();
        int stop = line.length();
        for (int i = 1; i < stop; ++i) {
            if (!Character.isWhitespace(line.charAt(i - 1)) || Character.isWhitespace(line.charAt(i))) continue;
            starts.add(i);
        }
        return starts;
    }

    public static String[] splitFixedWidth(String line, List<Integer> columnStarts) {
        if (line == null) {
            throw new GATKException("line is null");
        }
        if (columnStarts == null) {
            throw new GATKException("columnStarts is null");
        }
        int startCount = columnStarts.size();
        String[] row = new String[startCount + 1];
        if (startCount == 0) {
            row[0] = line.trim();
        } else {
            row[0] = line.substring(0, columnStarts.get(0)).trim();
            for (int i = 1; i < startCount; ++i) {
                row[i] = line.substring(columnStarts.get(i - 1), columnStarts.get(i)).trim();
            }
            row[startCount] = line.substring(columnStarts.get(startCount - 1)).trim();
        }
        return row;
    }

    public static String[] splitWhiteSpace(String line) {
        if (line == null) {
            throw new GATKException("line is null");
        }
        return line.trim().split("\\s+");
    }
}

