/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;

public final class XReadLines
implements Iterator<String>,
Iterable<String>,
AutoCloseable {
    private final BufferedReader in;
    private String nextLine = null;
    private final boolean trimWhitespace;
    private final String commentPrefix;

    public XReadLines(File filename) throws IOException {
        this(Utils.nonNull(filename).toPath(), true);
    }

    public XReadLines(Path path) throws IOException {
        this(path, true);
    }

    public XReadLines(Path path, boolean trimWhitespace) throws IOException {
        this(path, trimWhitespace, null);
    }

    public XReadLines(Path path, boolean trimWhitespace, String commentPrefix) throws IOException {
        this(IOUtils.makeReaderMaybeGzipped(path), trimWhitespace, commentPrefix);
    }

    public XReadLines(Reader reader, boolean trimWhitespace, String commentPrefix) {
        this.in = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.trimWhitespace = trimWhitespace;
        this.commentPrefix = commentPrefix;
        try {
            this.nextLine = this.readNextLine();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public List<String> readLines() {
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : this) {
            lines.add(line);
        }
        return lines;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.nextLine != null;
    }

    private String readNextLine() throws IOException {
        String nextLine;
        while ((nextLine = this.in.readLine()) != null && (this.trimWhitespace && (nextLine = nextLine.trim()).isEmpty() || this.commentPrefix != null && nextLine.startsWith(this.commentPrefix))) {
        }
        return nextLine;
    }

    @Override
    public String next() {
        try {
            String result = this.nextLine;
            this.nextLine = this.readNextLine();
            if (this.nextLine == null) {
                this.in.close();
            }
            return result;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

