/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.tsv;

import java.util.function.Function;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public final class DataLine {
    public static final long NO_LINE_NUMBER = -1L;
    private final long lineNumber;
    private final String[] values;
    private int nextIndex = 0;
    private final TableColumnCollection columns;
    private Function<String, RuntimeException> formatErrorFactory;
    private static final String FALSE_STRING = Boolean.toString(false);
    private static final String TRUE_STRING = Boolean.toString(true);

    DataLine(long lineNumber, String[] values, TableColumnCollection columns, Function<String, RuntimeException> formatErrorFactory) {
        this.lineNumber = lineNumber;
        this.values = Utils.nonNull(values, "the value array cannot be null");
        this.columns = Utils.nonNull(columns, "the columns cannot be null");
        this.formatErrorFactory = Utils.nonNull(formatErrorFactory, "the format error factory cannot be null");
        if (values.length != columns.columnCount()) {
            throw new IllegalArgumentException("mismatching value length and column count");
        }
    }

    public DataLine(long lineNumber, TableColumnCollection columns, Function<String, RuntimeException> formatErrorFactory) {
        this(lineNumber, new String[Utils.nonNull(columns, "the columns cannot be null").columnCount()], columns, formatErrorFactory);
    }

    DataLine(String[] fields, TableColumnCollection columns, Function<String, RuntimeException> formatErrorFactory) {
        this(-1L, fields, columns, formatErrorFactory);
    }

    public DataLine(TableColumnCollection columns, Function<String, RuntimeException> formatErrorFactory) {
        this(-1L, columns, formatErrorFactory);
    }

    public TableColumnCollection columns() {
        return this.columns;
    }

    String[] unpack() {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != null) continue;
            throw new IllegalStateException(String.format("some data line value remains undefined: e.g. column '%s' index %d", this.columns.nameAt(i), i));
        }
        return this.values;
    }

    public DataLine set(String name, String value) {
        return this.set(this.columnIndex(name), value);
    }

    public DataLine set(String name, boolean value) {
        return this.set(this.columnIndex(name), Boolean.toString(value));
    }

    public DataLine set(String name, int value) {
        return this.set(name, Integer.toString(value));
    }

    public DataLine set(String name, long value) {
        return this.set(name, Long.toString(value));
    }

    public DataLine set(String name, double value) {
        return this.set(this.columnIndex(name), value);
    }

    public DataLine set(String name, double value, int numDecimals) {
        return this.set(this.columnIndex(name), value, numDecimals);
    }

    public DataLine set(int index, String value) {
        Utils.validIndex(index, this.values.length);
        if (index == 0 && value != null && value.startsWith("#")) {
            throw new IllegalArgumentException("the value of the first column cannot start with the comment prefix: #");
        }
        this.values[index] = value;
        return this;
    }

    public DataLine set(int index, int value) {
        return this.set(index, Integer.toString(value));
    }

    public DataLine set(int index, long value) {
        return this.set(index, Long.toString(value));
    }

    public DataLine set(int index, double value) {
        long rounded = Math.round(value);
        if ((double)rounded == value) {
            this.set(index, Long.toString(rounded));
        } else {
            this.set(index, Double.toString(value));
        }
        return this.set(index, Double.toString(value));
    }

    public DataLine set(int index, double value, int numDecimals) {
        return this.set(index, MathUtils.roundToNDecimalPlaces(value, numDecimals));
    }

    public String get(int index) {
        Utils.validIndex(index, this.values.length);
        Utils.validate(this.values[index] != null, () -> "requested column value at " + index + " has not been initialized yet");
        return this.values[index];
    }

    public String get() {
        String result = this.get(this.nextIndex);
        ++this.nextIndex;
        return result;
    }

    public int getInt(int index) {
        try {
            return Integer.parseInt(this.get(index));
        }
        catch (NumberFormatException ex) {
            throw this.formatErrorFactory.apply(String.format("expected int value for column %s but found %s", this.columns.nameAt(index), this.get(index)));
        }
    }

    public int getInt() {
        return this.getInt(this.nextIndex++);
    }

    public long getLong(int index) {
        try {
            return Long.parseLong(this.get(index));
        }
        catch (NumberFormatException ex) {
            throw this.formatErrorFactory.apply(String.format("expected long value for column %s but found %s", this.columns.nameAt(index), this.get(index)));
        }
    }

    public long getLong() {
        long result = this.getLong(this.nextIndex);
        ++this.nextIndex;
        return result;
    }

    public boolean getBoolean(int index) {
        String string = this.get(index);
        if (string.equals(TRUE_STRING)) {
            return true;
        }
        if (string.equals(FALSE_STRING)) {
            return false;
        }
        throw this.formatErrorFactory.apply(String.format("Boolean value must be '%s' or '%s' (case sensitive) for column %s but found %s", TRUE_STRING, FALSE_STRING, this.columns.nameAt(index), this.get(index)));
    }

    public double getDouble(int index) {
        return this.getDouble(index, null);
    }

    public double getDouble(int index, Function<String, RuntimeException> formatErrorFactory) {
        try {
            return Double.parseDouble(this.get(index));
        }
        catch (NumberFormatException ex) {
            if (formatErrorFactory != null) {
                throw formatErrorFactory.apply(String.format("expected int value for column %s but found %s", this.columns.nameAt(index), this.get(index)));
            }
            throw this.formatErrorFactory.apply(String.format("expected int value for column %s but found %s", this.columns.nameAt(index), this.get(index)));
        }
    }

    public String get(String columnName) {
        int index = this.columnIndex(columnName);
        Utils.validate(this.values[index] != null, () -> String.format("the value for column '%s' is undefined", columnName));
        return this.values[index];
    }

    public String get(String columnName, String defaultValue) {
        int index = this.columns.indexOf(columnName);
        if (index < 0) {
            return defaultValue;
        }
        return this.values[index];
    }

    private int columnIndex(String columnName) {
        int index = this.columns.indexOf(columnName);
        if (index < 0) {
            throw new IllegalArgumentException("there is no such column: " + columnName);
        }
        return index;
    }

    public int getInt(String columnName) {
        return this.getInt(this.columnIndex(columnName));
    }

    public long getLong(String columnName) {
        return this.getLong(this.columnIndex(columnName));
    }

    public long getLong(Enum<?> column) {
        return this.getLong(Utils.nonNull(column).toString());
    }

    public boolean getBoolean(String columnName) {
        return this.getBoolean(this.columnIndex(columnName));
    }

    public double getDouble(String columnName) {
        return this.getDouble(this.columnIndex(columnName));
    }

    public String get(Enum<?> column) {
        return this.get(Utils.nonNull(column).toString());
    }

    public int getInt(Enum<?> column) {
        return this.getInt(Utils.nonNull(column).toString());
    }

    public double getDouble(Enum<?> column) {
        return this.getDouble(Utils.nonNull(column).toString());
    }

    public DataLine append(String value) {
        Utils.validate(this.nextIndex < this.values.length, "gone beyond of the end of the data-line");
        this.values[this.nextIndex++] = value;
        return this;
    }

    public DataLine append(int value) {
        return this.append(Integer.toString(value));
    }

    public DataLine append(long value) {
        return this.append(Long.toString(value));
    }

    public DataLine append(long ... values) {
        for (long l : Utils.nonNull(values, "the values cannot be null")) {
            this.append(l);
        }
        return this;
    }

    public DataLine append(double value) {
        long rounded = Math.round(value);
        if ((double)rounded == value) {
            return this.append(Long.toString(rounded));
        }
        return this.append(Double.toString(value));
    }

    public DataLine append(int ... values) {
        for (int i : Utils.nonNull(values, "the values cannot be null")) {
            this.append(i);
        }
        return this;
    }

    public DataLine append(String ... values) {
        for (String v : Utils.nonNull(values, "the values cannot be null")) {
            this.append(v);
        }
        return this;
    }

    public DataLine append(double ... values) {
        for (double d : Utils.nonNull(values, "the values cannot be null")) {
            this.append(d);
        }
        return this;
    }

    public DataLine setAll(String ... values) {
        Utils.nonNull(values, "the input values cannot be null");
        if (values.length != this.values.length) {
            throw new IllegalArgumentException("the input value length must be equal to the total number of columns ");
        }
        if (values[0] != null && values[0].startsWith("#")) {
            throw new IllegalArgumentException("first column value cannot start as a comment: #");
        }
        System.arraycopy(values, 0, this.values, 0, values.length);
        return this;
    }

    public DataLine seek(int index) {
        this.nextIndex = Utils.validIndex(index, this.values.length + 1);
        return this;
    }

    public DataLine seek(String columnName) {
        this.nextIndex = this.columnIndex(columnName);
        return this;
    }

    public DataLine seek(Enum<?> column) {
        this.nextIndex = this.columnIndex(Utils.nonNull(column).toString());
        return this;
    }

    public String[] toArray() {
        return (String[])this.values.clone();
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public byte getByte(int index) {
        try {
            return Byte.parseByte(this.get(index));
        }
        catch (NumberFormatException ex) {
            throw this.formatErrorFactory.apply(String.format("expected byte value for column %s but found %s", this.columns.nameAt(index), this.get(index)));
        }
    }

    public byte getByte(String column) {
        return this.getByte(this.columnIndex(column));
    }

    public byte getByte() {
        return this.getByte(this.nextIndex++);
    }
}

