/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.tsv;

import com.opencsv.CSVWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;

public class SimpleXSVWriter
implements Closeable {
    private int expectedNumColumns;
    private Map<String, Integer> headerMap = null;
    private CSVWriter outputWriter;
    private LineBuilder currentLineBuilder = null;

    public SimpleXSVWriter(Path path, char separator) throws IOException {
        this(new OutputStreamWriter(Files.newOutputStream(Utils.nonNull(path, "The path cannot be null."), new OpenOption[0])), separator);
    }

    public SimpleXSVWriter(Writer writer, char separator) {
        Utils.validate(separator != '\n', "Column separator cannot be a newline character");
        this.outputWriter = new CSVWriter(writer, separator);
    }

    public void setHeaderLine(List<String> columns) {
        if (this.headerMap != null) {
            throw new GATKException("Cannot modify header line once set");
        }
        this.outputWriter.writeNext(columns.toArray(new String[0]), false);
        this.expectedNumColumns = columns.size();
        this.headerMap = new HashMap<String, Integer>();
        for (int i = 0; i < columns.size(); ++i) {
            Utils.nonNull(columns.get(i), "Provided header had null column at position: " + i);
            if (this.headerMap.putIfAbsent(columns.get(i), i) == null) continue;
            throw new GATKException("Column names must be unique, but found a duplicate name: " + columns.get(i));
        }
    }

    private void writeLine(String[] line) {
        this.outputWriter.writeNext(line, false);
        this.currentLineBuilder = null;
    }

    public LineBuilder getNewLineBuilder() {
        if (this.headerMap == null) {
            throw new GATKException("Cannot construct line without first setting the header line");
        }
        if (this.currentLineBuilder != null) {
            this.currentLineBuilder.write();
        }
        this.currentLineBuilder = new LineBuilder(this.expectedNumColumns);
        return this.currentLineBuilder;
    }

    public Integer getIndexForColumn(String column) {
        Utils.nonNull(this.headerMap, "Cannot request column index if the header has not been specified");
        Integer index = this.headerMap.get(column);
        Utils.nonNull(index, "Requested column " + column + " does not exist in the provided header");
        return index;
    }

    @Override
    public void close() throws IOException {
        if (this.currentLineBuilder != null) {
            this.currentLineBuilder.write();
        }
        this.outputWriter.close();
    }

    public class LineBuilder {
        String[] lineToBuild;
        boolean hasBuilt = false;

        LineBuilder(int lineLength) {
            this.lineToBuild = new String[lineLength];
        }

        public LineBuilder setRow(String[] row) {
            this.checkAlterationAfterWrite();
            Utils.validate(row.length == this.lineToBuild.length, "Provided line must have the correct number of columns");
            for (int i = 0; i < row.length; ++i) {
                this.lineToBuild[i] = row[i];
            }
            return this;
        }

        public LineBuilder setRow(List<String> row) {
            this.checkAlterationAfterWrite();
            Utils.validate(row.size() == this.lineToBuild.length, "Provided line must have the correct number of columns");
            for (int i = 0; i < row.size(); ++i) {
                this.lineToBuild[i] = row.get(i);
            }
            return this;
        }

        public LineBuilder setColumn(int index, String value) {
            this.checkAlterationAfterWrite();
            this.lineToBuild[index] = value;
            return this;
        }

        public LineBuilder setColumn(String heading, String value) {
            int index = SimpleXSVWriter.this.getIndexForColumn(heading);
            return this.setColumn(index, value);
        }

        public LineBuilder fill(String filling) {
            this.checkAlterationAfterWrite();
            for (int i = 0; i < this.lineToBuild.length; ++i) {
                if (this.lineToBuild[i] != null) continue;
                this.lineToBuild[i] = filling;
            }
            return this;
        }

        public void write() {
            Utils.validate(!Arrays.stream(this.lineToBuild).anyMatch(Objects::isNull), "Attempted to construct an incomplete line, make sure all columns are filled");
            SimpleXSVWriter.this.writeLine(this.lineToBuild);
            this.hasBuilt = true;
        }

        private void checkAlterationAfterWrite() {
            Utils.validate(!this.hasBuilt, "Cannot make alterations to an already written out CSV line");
        }
    }
}

