/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.tsv;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.broadinstitute.hellbender.utils.Utils;

public final class TableColumnCollection {
    private final List<String> names;
    private final Map<String, Integer> indexByName;

    public TableColumnCollection(Iterable<String> names) {
        this((String[])Utils.stream(Utils.nonNull(names, "the names cannot be null")).toArray(String[]::new));
    }

    public TableColumnCollection(String ... names) {
        this.names = Collections.unmodifiableList(Arrays.asList(TableColumnCollection.checkNames((String[])names.clone(), IllegalArgumentException::new)));
        this.indexByName = IntStream.range(0, names.length).boxed().collect(Collectors.toMap(this.names::get, Function.identity()));
    }

    public TableColumnCollection(Object ... names) {
        this.names = Collections.unmodifiableList(Arrays.asList(TableColumnCollection.checkNames(names, IllegalArgumentException::new)));
        this.indexByName = IntStream.range(0, names.length).boxed().collect(Collectors.toMap(this.names::get, Function.identity()));
    }

    public TableColumnCollection(Class<? extends Enum<?>> enumClass) {
        Utils.nonNull(enumClass);
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException("the input class must be an enum class");
        }
        this.names = Collections.unmodifiableList(Stream.of(enumClass.getEnumConstants()).map(Object::toString).collect(Collectors.toList()));
        TableColumnCollection.checkNames(this.names.toArray(new String[this.names.size()]), IllegalArgumentException::new);
        this.indexByName = IntStream.range(0, this.names.size()).boxed().collect(Collectors.toMap(this.names::get, Function.identity()));
    }

    public static TableColumnCollection make(String ... columnNames) {
        TableColumnCollection.checkNames(columnNames, IllegalArgumentException::new);
        return new TableColumnCollection(columnNames);
    }

    public List<String> names() {
        return this.names;
    }

    public String nameAt(int index) {
        Utils.validIndex(index, this.names.size());
        return this.names.get(index);
    }

    public int indexOf(String name) {
        Utils.nonNull(name, "the column name cannot be null");
        return this.indexByName.getOrDefault(name, -1);
    }

    public boolean contains(String name) {
        return this.indexByName.containsKey(Utils.nonNull(name, "cannot be null"));
    }

    public boolean containsAll(String ... names) {
        return Stream.of((Object[])Utils.nonNull(names, "names cannot be null")).allMatch(this::contains);
    }

    public boolean containsAll(Iterable<String> names) {
        for (String name : Utils.nonNull(names, "names cannot be null")) {
            if (this.contains(name)) continue;
            return false;
        }
        return true;
    }

    public boolean containsExactly(String ... names) {
        return this.containsAll(names) && this.columnCount() == names.length;
    }

    public boolean matches(int index, String name) {
        if (index >= this.names.size()) {
            return false;
        }
        return this.names.get(Utils.validIndex(index, this.names.size())).equals(Utils.nonNull(name, "name cannot be null"));
    }

    public boolean matchesAll(int offset, String ... names) {
        Utils.validIndex(offset, this.names.size() + 1);
        int toIndex = offset + names.length;
        if (toIndex > this.names.size()) {
            return false;
        }
        for (int i = 0; i < names.length; ++i) {
            if (this.names.get(offset + i).equals(names[i])) continue;
            return false;
        }
        return true;
    }

    public boolean matchesExactly(String ... names) {
        return this.matchesAll(0, names) && names.length == this.names.size();
    }

    public int columnCount() {
        return this.names.size();
    }

    public static String[] checkNames(Object[] columnNames, Function<String, RuntimeException> exceptionFactory) {
        Utils.nonNull(columnNames, "column names cannot be null");
        String[] stringNames = new String[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            stringNames[i] = Utils.nonNull(columnNames[i], "no column name can be null: e.g. " + i + " element").toString();
        }
        return TableColumnCollection.checkNames(stringNames, exceptionFactory);
    }

    public static String[] checkNames(String[] columnNames, Function<String, RuntimeException> exceptionFactory) {
        Utils.nonNull(columnNames, "column names cannot be null");
        Utils.nonNull(exceptionFactory, "exception factory cannot be null");
        if (columnNames.length == 0) {
            throw Utils.nonNull(exceptionFactory.apply("there must be at least one column"));
        }
        HashSet<String> columnNameSet = new HashSet<String>(columnNames.length);
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = Utils.nonNull(columnNames[i], "no column name can be null: e.g. " + i + " element");
            if (columnNameSet.add(columnName)) continue;
            throw Utils.nonNull(exceptionFactory.apply("more than one column have the same name: " + columnNames[i]), "exception factory produces null exceptions");
        }
        if (columnNames[0].startsWith("#")) {
            throw Utils.nonNull(exceptionFactory.apply("the first column name cannot start with the comment prefix"), "exception factory produces null exceptions");
        }
        return columnNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableColumnCollection that = (TableColumnCollection)o;
        return this.names.equals(that.names) && this.indexByName.equals(that.indexByName);
    }

    public int hashCode() {
        int result = this.names.hashCode();
        result = 31 * result + this.indexByName.hashCode();
        return result;
    }
}

