/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.tsv;

import com.opencsv.CSVReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.exceptions.UserException;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.io.IOUtils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableUtils;

public abstract class TableReader<R>
implements Closeable,
Iterable<R> {
    private final String source;
    private final LineNumberReader reader;
    private TableColumnCollection columns;
    private Map<String, String> metadata = new HashMap<String, String>();
    private CSVReader csvReader;
    private boolean nextRecordFetched = false;
    private R nextRecord;

    public TableReader(Path path) throws IOException {
        this(Utils.nonNull(path, "the input file cannot be null").toString(), IOUtils.makeReaderMaybeGzipped(path));
    }

    public TableReader(Reader sourceReader) throws IOException {
        this(null, sourceReader);
    }

    protected TableReader(String sourceName, Reader sourceReader) throws IOException {
        Utils.nonNull(sourceReader, "the reader cannot be null");
        this.source = sourceName;
        this.reader = sourceReader instanceof LineNumberReader ? (LineNumberReader)sourceReader : new LineNumberReader(sourceReader);
        this.csvReader = new CSVReader((Reader)this.reader, '\t', '\"', '\\');
        this.findAndProcessHeaderLine();
        this.nextRecordFetched = false;
    }

    protected void findAndProcessHeaderLine() throws IOException {
        String[] line = this.skipCommentLines();
        if (line == null) {
            throw this.formatException("premature end of table: header line not found");
        }
        TableColumnCollection.checkNames(line, UserException.BadInput::new);
        this.columns = new TableColumnCollection(line);
        this.processColumns(this.columns);
    }

    protected boolean isCommentLine(String[] line) {
        return line.length > 0 && line[0].startsWith("#");
    }

    protected final UserException.BadInput formatException(String message) {
        return new UserException.BadInput(this.formatExceptionMessageWithLocationInfo(message));
    }

    protected final UserException.BadInput formatExceptionWithoutLocation(String message) {
        return new UserException.BadInput(this.formatExceptionMessageWithoutLocationInfo(message));
    }

    private String formatExceptionMessageWithLocationInfo(String message) {
        String explanation;
        String string = explanation = message == null ? "" : ": " + message;
        if (this.source == null) {
            return String.format("format error at line %d" + explanation, this.reader.getLineNumber());
        }
        return String.format("format error in '%s' at line %d" + explanation, this.source, this.reader.getLineNumber());
    }

    private String formatExceptionMessageWithoutLocationInfo(String message) {
        return "format error: " + message;
    }

    protected void processColumns(TableColumnCollection tableColumns) {
    }

    public TableColumnCollection columns() {
        Utils.validate(this.columns != null, "columns are null");
        return this.columns;
    }

    public final R readRecord() throws IOException {
        if (!this.nextRecordFetched) {
            this.nextRecord = this.fetchNextRecord();
        }
        if (this.nextRecord != null) {
            this.nextRecordFetched = false;
            return this.nextRecord;
        }
        return null;
    }

    public final R readRecord(String line) {
        try {
            String[] fields = this.csvReader.getParser().parseLine(line);
            if (this.isCommentLine(fields) || this.isHeaderLine(fields)) {
                return null;
            }
            if (fields.length != this.columns.columnCount()) {
                throw this.formatExceptionWithoutLocation("invalid number of columns");
            }
            return this.createRecord(new DataLine(fields, this.columns, this::formatExceptionWithoutLocation));
        }
        catch (IOException ex) {
            throw new GATKException("the single line input is in fact a multi-line entry");
        }
    }

    private R fetchNextRecord() throws IOException {
        String[] line;
        this.nextRecordFetched = true;
        while ((line = this.csvReader.readNext()) != null) {
            if (this.isCommentLine(line)) {
                this.processCommentLine(line, (long)this.reader.getLineNumber());
                continue;
            }
            if (this.isHeaderLine(line)) continue;
            if (line.length != this.columns.columnCount()) {
                throw this.formatException(String.format("mismatch between number of values in line (%d) and number of columns (%d)", line.length, this.columns.columnCount()));
            }
            R result = this.createRecord(new DataLine(this.reader.getLineNumber(), line, this.columns, this::formatException));
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void processCommentLine(String[] line, long lineNumber) {
        StringBuilder builder = new StringBuilder();
        builder.append(line[0].substring("#".length()));
        for (int i = 1; i < line.length; ++i) {
            builder.append(TableUtils.COLUMN_SEPARATOR_STRING).append(line[i]);
        }
        this.processCommentLine(builder.toString(), lineNumber);
    }

    protected void processCommentLine(String commentText, long lineNumber) {
        if (commentText.startsWith("<METADATA>")) {
            String[] keyAndValue = commentText.substring("<METADATA>".length()).split("=");
            this.metadata.put(keyAndValue[0], keyAndValue[1]);
        }
    }

    protected boolean isHeaderLine(String[] line) {
        return this.columns.matchesExactly(line);
    }

    private String[] skipCommentLines() throws IOException {
        String[] line;
        while ((line = this.csvReader.readNext()) != null && this.isCommentLine(line)) {
            this.processCommentLine(line, (long)this.reader.getLineNumber());
        }
        return line;
    }

    protected abstract R createRecord(DataLine var1);

    @Override
    public void close() throws IOException {
        this.csvReader.close();
    }

    @Override
    public Iterator<R> iterator() {
        return new Iterator<R>(){

            @Override
            public boolean hasNext() {
                if (!TableReader.this.nextRecordFetched) {
                    try {
                        TableReader.this.nextRecord = TableReader.this.fetchNextRecord();
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
                return TableReader.this.nextRecord != null;
            }

            @Override
            public R next() {
                if (!TableReader.this.nextRecordFetched) {
                    try {
                        TableReader.this.nextRecord = TableReader.this.fetchNextRecord();
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
                if (TableReader.this.nextRecord == null) {
                    throw new NoSuchElementException("there is no more record in the input");
                }
                TableReader.this.nextRecordFetched = false;
                return TableReader.this.nextRecord;
            }
        };
    }

    @Override
    public Spliterator<R> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 272);
    }

    public Stream<R> stream() {
        return Utils.stream(this);
    }

    public List<R> toList() {
        return this.stream().collect(Collectors.toList());
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getSource() {
        return this.source;
    }
}

