/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.tsv;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;
import org.broadinstitute.hellbender.utils.tsv.TableReader;
import org.broadinstitute.hellbender.utils.tsv.TableWriter;

public final class TableUtils {
    public static final char COLUMN_SEPARATOR = '\t';
    public static final String COLUMN_SEPARATOR_STRING = String.valueOf('\t');
    public static final String COMMENT_PREFIX = "#";
    public static final char QUOTE_CHARACTER = '\"';
    public static final String QUOTE_STRING = String.valueOf('\"');
    public static final char ESCAPE_CHARACTER = '\\';
    public static final String ESCAPE_STRING = String.valueOf('\\');
    public static final String SAMPLE_METADATA_TAG = "SAMPLE";

    public static <R> TableReader<R> reader(Path path, final BiFunction<TableColumnCollection, Function<String, RuntimeException>, Function<DataLine, R>> recordExtractorFactory) throws IOException {
        Utils.nonNull(recordExtractorFactory, "the record extractor factory cannot be null");
        return new TableReader<R>(path){
            private Function<DataLine, R> recordExtractor;

            @Override
            protected void processColumns(TableColumnCollection columns) {
                this.recordExtractor = (Function)recordExtractorFactory.apply(columns, this::formatException);
                Utils.validate(this.recordExtractor != null, "the record extractor function cannot be null");
            }

            @Override
            protected R createRecord(DataLine dataLine) {
                return this.recordExtractor.apply(dataLine);
            }
        };
    }

    public static <R> TableReader<R> reader(Reader reader, final BiFunction<TableColumnCollection, Function<String, RuntimeException>, Function<DataLine, R>> recordExtractorFactory) throws IOException {
        Utils.nonNull(recordExtractorFactory, "the record extractor factory cannot be null");
        return new TableReader<R>(reader){
            private Function<DataLine, R> recordExtractor;

            @Override
            protected void processColumns(TableColumnCollection columns) {
                this.recordExtractor = (Function)recordExtractorFactory.apply(columns, this::formatException);
                Utils.validate(this.recordExtractor != null, "the record extractor function cannot be null");
            }

            @Override
            protected R createRecord(DataLine dataLine) {
                return this.recordExtractor.apply(dataLine);
            }
        };
    }

    public static <R> TableReader<R> reader(String sourceName, Reader reader, final BiFunction<TableColumnCollection, Function<String, RuntimeException>, Function<DataLine, R>> recordExtractorFactory) throws IOException {
        Utils.nonNull(recordExtractorFactory, "the record extractor factory cannot be null");
        return new TableReader<R>(sourceName, reader){
            private Function<DataLine, R> recordExtractor;

            @Override
            protected void processColumns(TableColumnCollection columns) {
                this.recordExtractor = (Function)recordExtractorFactory.apply(columns, this::formatException);
                Utils.validate(this.recordExtractor != null, "the record extractor function cannot be null");
            }

            @Override
            protected R createRecord(DataLine dataLine) {
                return this.recordExtractor.apply(dataLine);
            }
        };
    }

    public static <R> TableWriter<R> writer(Path path, TableColumnCollection columns, BiConsumer<R, DataLine> dataLineComposer) throws IOException {
        return new DataLineComposerBasedTableWriter(path, columns, dataLineComposer);
    }

    public static <R> TableWriter<R> writer(Writer writer, TableColumnCollection columns, BiConsumer<R, DataLine> dataLineComposer) throws IOException {
        return new DataLineComposerBasedTableWriter(writer, columns, dataLineComposer);
    }

    public static void checkMandatoryColumns(TableColumnCollection columns, TableColumnCollection mandatoryColumns, Function<String, RuntimeException> formatExceptionFactory) {
        if (!columns.containsAll(mandatoryColumns.names())) {
            Sets.SetView missingColumns = Sets.difference(new HashSet<String>(mandatoryColumns.names()), new HashSet<String>(columns.names()));
            throw formatExceptionFactory.apply("Bad header in file.  Not all mandatory columns are present.  Missing: " + StringUtils.join((Iterable)missingColumns, (String)", "));
        }
    }

    private TableUtils() {
        throw new UnsupportedOperationException();
    }

    private static final class DataLineComposerBasedTableWriter<R>
    extends TableWriter<R> {
        private final BiConsumer<R, DataLine> dataLineComposer;

        private DataLineComposerBasedTableWriter(Path path, TableColumnCollection columns, BiConsumer<R, DataLine> dataLineComposer) throws IOException {
            super(path, columns);
            this.dataLineComposer = Utils.nonNull(dataLineComposer, "the data-line composer cannot be null");
        }

        private DataLineComposerBasedTableWriter(Writer writer, TableColumnCollection columns, BiConsumer<R, DataLine> dataLineComposer) throws IOException {
            super(writer, columns);
            this.dataLineComposer = Utils.nonNull(dataLineComposer, "the data-line composer cannot be null");
        }

        @Override
        protected void composeLine(R record, DataLine dataLine) {
            this.dataLineComposer.accept(record, dataLine);
        }
    }
}

