/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.tsv;

import com.opencsv.CSVWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.tsv.DataLine;
import org.broadinstitute.hellbender.utils.tsv.TableColumnCollection;

public abstract class TableWriter<R>
implements Closeable {
    private long lineNumber;
    private final CSVWriter writer;
    private final TableColumnCollection columns;
    private boolean headerWritten = false;
    public static final String METADATA_TAG = "<METADATA>";

    public TableWriter(Path path, TableColumnCollection tableColumns) throws IOException {
        this(new OutputStreamWriter(Files.newOutputStream(Utils.nonNull(path, "The path cannot be null."), new OpenOption[0])), tableColumns);
    }

    public TableWriter(Writer writer, TableColumnCollection columns) throws IOException {
        this.columns = Utils.nonNull(columns, "The columns cannot be null.");
        this.writer = new CSVWriter(Utils.nonNull(writer, "the input writer cannot be null"), '\t', '\"', '\\');
    }

    public final void writeComment(String comment) throws IOException {
        Utils.nonNull(comment, "The comment cannot be null.");
        this.writer.writeNext(new String[]{"#" + comment}, false);
        ++this.lineNumber;
    }

    public final void writeMetadata(String key, String value) throws IOException {
        Utils.nonNull(key);
        Utils.nonNull(value);
        Utils.validateArg(!this.headerWritten, "Metadata must precede the header.");
        this.writeComment(METADATA_TAG + key + "=" + value);
    }

    public void writeRecord(R record) throws IOException {
        Utils.nonNull(record, "The record cannot be null.");
        this.writeHeaderIfApplies();
        DataLine dataLine = new DataLine(this.lineNumber + 1L, this.columns, IllegalArgumentException::new);
        this.composeLine(record, dataLine);
        this.writer.writeNext(dataLine.unpack(), false);
        ++this.lineNumber;
    }

    public final void writeAllRecords(Iterable<R> records) throws IOException {
        Utils.nonNull(records, "the record iterable cannot be null");
        for (R record : records) {
            this.writeRecord(record);
        }
    }

    @Override
    public final void close() throws IOException {
        this.writeHeaderIfApplies();
        this.writer.close();
    }

    public final void flush() throws IOException {
        this.writeHeaderIfApplies();
        this.writer.flush();
    }

    public void writeHeaderIfApplies() throws IOException {
        if (!this.headerWritten) {
            this.writer.writeNext(this.columns.names().toArray(new String[this.columns.columnCount()]), false);
            ++this.lineNumber;
        }
        this.headerWritten = true;
    }

    protected abstract void composeLine(R var1, DataLine var2);
}

