/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.variant;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.variant.DbSnpVariantType;

public final class DbSnpBitSetUtil {
    private final Map<String, BitSet> sequenceToBitSet = new LinkedHashMap<String, BitSet>();

    private DbSnpBitSetUtil() {
    }

    public DbSnpBitSetUtil(File dbSnpFile, SAMSequenceDictionary sequenceDictionary) {
        this(dbSnpFile, sequenceDictionary, EnumSet.noneOf(DbSnpVariantType.class));
    }

    public DbSnpBitSetUtil(File dbSnpFile, SAMSequenceDictionary sequenceDictionary, Collection<DbSnpVariantType> variantsToMatch) {
        Utils.nonNull(dbSnpFile);
        LinkedHashMap<DbSnpBitSetUtil, Set<DbSnpVariantType>> tmp = new LinkedHashMap<DbSnpBitSetUtil, Set<DbSnpVariantType>>();
        tmp.put(this, EnumSet.copyOf(variantsToMatch));
        DbSnpBitSetUtil.loadVcf(dbSnpFile, sequenceDictionary, tmp);
    }

    private static void loadVcf(File dbSnpFile, SAMSequenceDictionary sequenceDictionary, Map<DbSnpBitSetUtil, Set<DbSnpVariantType>> bitSetsToVariantTypes) {
        VCFFileReader variantReader = new VCFFileReader(dbSnpFile);
        CloseableIterator variantIterator = variantReader.iterator();
        while (variantIterator.hasNext()) {
            VariantContext kv = (VariantContext)variantIterator.next();
            for (Map.Entry<DbSnpBitSetUtil, Set<DbSnpVariantType>> tuple : bitSetsToVariantTypes.entrySet()) {
                DbSnpBitSetUtil bitset = tuple.getKey();
                Set<DbSnpVariantType> variantsToMatch = tuple.getValue();
                BitSet bits = bitset.sequenceToBitSet.get(kv.getContig());
                if (bits == null) {
                    int nBits = sequenceDictionary == null ? kv.getEnd() + 1 : sequenceDictionary.getSequence(kv.getContig()).getSequenceLength() + 1;
                    bits = new BitSet(nBits);
                    bitset.sequenceToBitSet.put(kv.getContig(), bits);
                }
                if (!(variantsToMatch.isEmpty() || kv.isSNP() && variantsToMatch.contains((Object)DbSnpVariantType.SNP) || kv.isIndel() && variantsToMatch.contains((Object)DbSnpVariantType.insertion)) && (!kv.isIndel() || !variantsToMatch.contains((Object)DbSnpVariantType.deletion))) continue;
                for (int i = kv.getStart(); i <= kv.getEnd(); ++i) {
                    bits.set(i, true);
                }
            }
        }
        CloserUtil.close((Object)variantIterator);
        CloserUtil.close((Object)variantReader);
    }

    public boolean isDbSnpSite(String sequenceName, int pos) {
        if (this.sequenceToBitSet.get(sequenceName) == null) {
            return false;
        }
        if (pos > this.sequenceToBitSet.get(sequenceName).length()) {
            return false;
        }
        return this.sequenceToBitSet.get(sequenceName).get(pos);
    }

    public static class DbSnpBitSets {
        public DbSnpBitSetUtil snps;
        public DbSnpBitSetUtil indels;
    }
}

