/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.variant;

import htsjdk.variant.variantcontext.Allele;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.broadinstitute.hellbender.tools.spark.sv.utils.GATKSVVCFConstants;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public class GATKSVVariantContextUtils {
    public static List<Allele> makeGenotypeAllelesFromCopyNumber(int copyNumberCall, int refCopyNumber, Allele refAllele) {
        int i;
        ArrayList<Allele> returnAlleles = new ArrayList<Allele>();
        Allele genotypeAllele = GATKSVVariantContextUtils.getAlleleForCopyNumber(copyNumberCall, refCopyNumber, refAllele);
        if (refCopyNumber == 0) {
            return GATKVariantContextUtils.noCallAlleles(1);
        }
        if (refCopyNumber == 1) {
            return Collections.singletonList(genotypeAllele);
        }
        if (genotypeAllele.equals((Object)GATKSVVCFConstants.DUP_ALLELE)) {
            return GATKVariantContextUtils.noCallAlleles(refCopyNumber);
        }
        if (refCopyNumber == 2) {
            if (copyNumberCall == 0) {
                returnAlleles.add(genotypeAllele);
            } else {
                returnAlleles.add(refAllele);
            }
            returnAlleles.add(genotypeAllele);
            return returnAlleles;
        }
        for (i = 0; i < copyNumberCall; ++i) {
            returnAlleles.add(refAllele);
        }
        for (i = copyNumberCall; i < refCopyNumber; ++i) {
            returnAlleles.add(GATKSVVCFConstants.DEL_ALLELE);
        }
        return returnAlleles;
    }

    public static Allele getAlleleForCopyNumber(int copyNumberCall, int refCopyNumber, Allele refAllele) {
        if (copyNumberCall > refCopyNumber) {
            return GATKSVVCFConstants.DUP_ALLELE;
        }
        if (copyNumberCall < refCopyNumber) {
            return GATKSVVCFConstants.DEL_ALLELE;
        }
        return refAllele;
    }
}

