/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.variant;

import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.hellbender.tools.walkers.annotator.AS_StrandBiasMutectAnnotation;
import org.broadinstitute.hellbender.tools.walkers.annotator.BaseQuality;
import org.broadinstitute.hellbender.tools.walkers.annotator.FragmentLength;
import org.broadinstitute.hellbender.tools.walkers.annotator.MappingQuality;
import org.broadinstitute.hellbender.tools.walkers.annotator.RMSMappingQuality;
import org.broadinstitute.hellbender.tools.walkers.annotator.ReadPosition;
import org.broadinstitute.hellbender.utils.Utils;

public class GATKVCFHeaderLines {
    private static final Map<String, VCFInfoHeaderLine> infoLines = new LinkedHashMap<String, VCFInfoHeaderLine>(60);
    private static final Map<String, VCFFormatHeaderLine> formatLines = new LinkedHashMap<String, VCFFormatHeaderLine>(25);
    private static final Map<String, VCFFilterHeaderLine> filterLines = new LinkedHashMap<String, VCFFilterHeaderLine>(2);

    public static VCFInfoHeaderLine getInfoLine(String id) {
        if (!infoLines.containsKey(id)) {
            throw new IllegalStateException("No VCF INFO header line found for key " + id);
        }
        return infoLines.get(id);
    }

    public static VCFFormatHeaderLine getFormatLine(String id) {
        if (!formatLines.containsKey(id)) {
            throw new IllegalStateException("No VCF FORMAT header line found for key " + id);
        }
        return formatLines.get(id);
    }

    public static VCFFilterHeaderLine getFilterLine(String id) {
        if (!filterLines.containsKey(id)) {
            throw new IllegalStateException("No VCF FILTER header line found for key " + id);
        }
        return filterLines.get(id);
    }

    public static Set<VCFInfoHeaderLine> getAllInfoLines() {
        return Collections.unmodifiableSet(new HashSet<VCFInfoHeaderLine>(infoLines.values()));
    }

    public static Set<VCFFormatHeaderLine> getAllFormatLines() {
        return Collections.unmodifiableSet(new HashSet<VCFFormatHeaderLine>(formatLines.values()));
    }

    public static Set<VCFFilterHeaderLine> getAllFilterLines() {
        return Collections.unmodifiableSet(new HashSet<VCFFilterHeaderLine>(filterLines.values()));
    }

    private static void addFormatLine(VCFFormatHeaderLine line) {
        Utils.nonNull(line);
        formatLines.put(line.getID(), line);
    }

    private static void addInfoLine(VCFInfoHeaderLine line) {
        Utils.nonNull(line);
        infoLines.put(line.getID(), line);
    }

    private static void addFilterLine(VCFFilterHeaderLine line) {
        Utils.nonNull(line);
        filterLines.put(line.getID(), line);
    }

    public static VCFFormatHeaderLine getEquivalentFormatHeaderLine(String infoFieldKey) {
        VCFInfoHeaderLine infoLine = GATKVCFHeaderLines.getInfoLine(infoFieldKey);
        if (infoLine.isFixedCount()) {
            return new VCFFormatHeaderLine(infoLine.getID(), infoLine.getCount(), infoLine.getType(), infoLine.getDescription());
        }
        return new VCFFormatHeaderLine(infoLine.getID(), infoLine.getCountType(), infoLine.getType(), infoLine.getDescription());
    }

    static {
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("SB_TABLE", 4, VCFHeaderLineType.Integer, "Forward/reverse read counts for strand bias tests"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("ABGQ", 1, VCFHeaderLineType.Integer, ":"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("ALTGQ", 1, VCFHeaderLineType.Integer, ":"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AC_adj", VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Allele count for each ALT, adjusted to represent high quality genotypes only"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("LowQual", "Low quality"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("PASS", "Site contains at least one allele that passes filters"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("alignment", "Alignment artifact"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("clustered_events", "Clustered events observed in the tumor"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("germline", "Evidence indicates this site is germline, not somatic"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("panel_of_normals", "Blacklisted site in panel of normals"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("weak_evidence", "Mutation does not meet likelihood threshold"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("slippage", "Site filtered due to contraction of short tandem repeat region"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("multiallelic", "Site filtered because too many alt alleles pass tumor LOD"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("strand_bias", "Evidence for alt allele comes from one read direction only"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("normal_artifact", "artifact_in_normal"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("base_qual", "alt median base quality"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("map_qual", "ref - alt median mapping quality"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("fragment", "abs(ref - alt) median fragment length"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("position", "median distance of alt variants from end of reads"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("contamination", "contamination"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("duplicate", "evidence for alt allele is overrepresented by apparent duplicates"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("orientation", "orientation bias detected by the orientation bias mixture model"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("haplotype", "Variant near filtered variant on same haplotype."));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("strict_strand", "Evidence for alt allele is not represented in both directions"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("n_ratio", "Ratio of N to alt exceeds specified ratio"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("low_allele_frac", "Allele fraction is below specified threshold"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("possible_numt", "Allele depth is below expected coverage of NuMT in autosome"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("mt_many_low_hets", "All low heteroplasmy sites are filtered when at least x low het sites pass all other filters"));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("FAIL", "Fail the site if all alleles fail but for different reasons."));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("SITE", "There are no allele specific filters that apply to this allele. Only site level filters apply."));
        GATKVCFHeaderLines.addFilterLine(new VCFFilterHeaderLine("mt_many_low_hets", "All low heteroplasmy sites are filtered when at least x low het sites pass all other filters"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("AB", 1, VCFHeaderLineType.Float, "Allele balance for each het genotype"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("MQ0", 1, VCFHeaderLineType.Integer, "Number of Mapping Quality Zero Reads per sample"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("SAC", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.Integer, "Number of reads on the forward and reverse strand supporting each allele (including reference)"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("SB", 4, VCFHeaderLineType.Integer, "Per-sample component statistics which comprise the Fisher's Exact Test to detect strand bias."));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("PID", 1, VCFHeaderLineType.String, "Physical phasing ID information, where each unique ID within a given sample (but not across samples) connects records within a phasing group"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("PGT", 1, VCFHeaderLineType.String, "Physical phasing haplotype information, describing how the alternate alleles are phased in relation to one another; will always be heterozygous and is not intended to describe called alleles"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("MIN_DP", 1, VCFHeaderLineType.Integer, "Minimum DP observed within the GVCF block"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("RGQ", 1, VCFHeaderLineType.Integer, "Unconditional reference genotype confidence, encoded as a phred quality -10*log10 p(genotype call is wrong)"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("TP", 1, VCFHeaderLineType.Integer, "Phred score of the genotype combination and phase given that the genotypes are correct"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("PP", VCFHeaderLineCount.G, VCFHeaderLineType.Integer, "Phred-scaled Posterior Genotype Probabilities"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("JL", 1, VCFHeaderLineType.Integer, "Phred-scaled joint likelihood of the genotype combination (before applying family priors)"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("JP", 1, VCFHeaderLineType.Integer, "Phred-scaled joint posterior probability of the genotype combination (after applying family priors)"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("AF", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Allele fractions of alternate alleles in the tumor"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("F1R2", VCFHeaderLineCount.R, VCFHeaderLineType.Integer, "Count of reads in F1R2 pair orientation supporting each allele"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("F2R1", VCFHeaderLineCount.R, VCFHeaderLineType.Integer, "Count of reads in F2R1 pair orientation supporting each allele"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("MLEAC", VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Maximum likelihood expectation (MLE) for the allele counts (not necessarily the same as the AC), for each ALT allele, in the same order as listed"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("MLEAF", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Maximum likelihood expectation (MLE) for the allele frequency (not necessarily the same as the AF), for each ALT allele, in the same order as listed"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("DS", 0, VCFHeaderLineType.Flag, "Were any of the samples downsampled?"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("BaseQRankSum", 1, VCFHeaderLineType.Float, "Z-score from Wilcoxon rank sum test of Alt Vs. Ref base qualities"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_BaseQRankSum", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "allele specific Z-score from Wilcoxon rank sum test of each Alt Vs. Ref base qualities"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_RAW_BaseQRankSum", 1, VCFHeaderLineType.String, "raw data for allele specific rank sum test of base qualities"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("ClippingRankSum", 1, VCFHeaderLineType.Float, "Z-score From Wilcoxon rank sum test of Alt vs. Ref number of hard clipped bases"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("FS", 1, VCFHeaderLineType.Float, "Phred-scaled p-value using Fisher's exact test to detect strand bias"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_FS", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "allele specific phred-scaled p-value using Fisher's exact test to detect strand bias of each alt allele"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_SB_TABLE", 1, VCFHeaderLineType.String, "Allele-specific forward/reverse read counts for strand bias tests. Includes the reference and alleles separated by |."));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("NCC", 1, VCFHeaderLineType.Integer, "Number of no-called samples"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("GQ_MEAN", 1, VCFHeaderLineType.Float, "Mean of all GQ values"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("GQ_STDDEV", 1, VCFHeaderLineType.Float, "Standard deviation of all GQ values"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("HaplotypeScore", 1, VCFHeaderLineType.Float, "Consistency of the site with at most two segregating haplotypes"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("InbreedingCoeff", 1, VCFHeaderLineType.Float, "Inbreeding coefficient as estimated from the genotype likelihoods per-sample when compared against the Hardy-Weinberg expectation"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_InbreedingCoeff", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Allele-specific inbreeding coefficient as estimated from the genotype likelihoods per-sample when compared against the Hardy-Weinberg expectation"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("ExcessHet", 1, VCFHeaderLineType.Float, "Phred-scaled p-value for exact test of excess heterozygosity"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("RAW_GT_COUNT", 3, VCFHeaderLineType.Integer, "Counts of genotypes w.r.t. the reference allele: 0/0, 0/*, */*, i.e. all alts lumped together; for use in calculating excess heterozygosity"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("LikelihoodRankSum", 1, VCFHeaderLineType.Float, "Z-score from Wilcoxon rank sum test of Alt Vs. Ref haplotype likelihoods"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("MQRankSum", 1, VCFHeaderLineType.Float, "Z-score From Wilcoxon rank sum test of Alt vs. Ref read mapping qualities"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_MQRankSum", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "allele specific Z-score From Wilcoxon rank sum test of each Alt vs. Ref read mapping qualities"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("MQ_DP", 1, VCFHeaderLineType.Integer, "Depth over variant samples for better MQ calculation (deprecated -- use RAW_MQandDP instead.)"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("RAW_MQ", 1, VCFHeaderLineType.Float, "Raw data for RMS Mapping Quality (deprecated -- use RAW_MQandDP instead.)"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("RAW_MQandDP", 2, VCFHeaderLineType.Integer, "Raw data (sum of squared MQ and total depth) for improved RMS Mapping Quality calculation. Incompatible with deprecated " + RMSMappingQuality.getDeprecatedRawKeyName() + " formulation."));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_RAW_MQ", 1, VCFHeaderLineType.String, "Allele-specfic raw data for RMS Mapping Quality"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_MQ", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Allele-specific RMS Mapping Quality"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_RAW_MQRankSum", 1, VCFHeaderLineType.String, "Allele-specfic raw data for Mapping Quality Rank Sum"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_MQRankSum", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Allele-specific Mapping Quality Rank Sum"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_FilterStatus", VCFHeaderLineCount.A, VCFHeaderLineType.String, "Filter status for each allele, as assessed by ApplyVQSR. Note that the VCF filter field will reflect the most lenient/sensitive status across all alleles."));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_culprit", VCFHeaderLineCount.A, VCFHeaderLineType.String, "For each alt allele, the annotation which was the worst performing in the Gaussian mixture model, likely the reason why the variant was filtered out"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_VQSLOD", VCFHeaderLineCount.A, VCFHeaderLineType.String, "For each alt allele, the log odds of being a true variant versus being false under the trained gaussian mixture model"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("hiConfDeNovo", 1, VCFHeaderLineType.String, "High confidence possible de novo mutation (GQ >= 20 for all trio members)=[comma-delimited list of child samples]"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("loConfDeNovo", 1, VCFHeaderLineType.String, "Low confidence possible de novo mutation (GQ >= 10 for child, GQ > 0 for parents)=[comma-delimited list of child samples]"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("QD", 1, VCFHeaderLineType.Float, "Variant Confidence/Quality by Depth"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_QD", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Allele-specific Variant Confidence/Quality by Depth"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_QUAL", 1, VCFHeaderLineType.Float, "Allele-specific Variant Qual Score"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_QUALapprox", 1, VCFHeaderLineType.String, "Allele-specific Variant Qual approximation"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("QUALapprox", 1, VCFHeaderLineType.Integer, "Sum of PL[0] values; used to approximate the QUAL score"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_QUALapprox", 1, VCFHeaderLineType.String, "Allele-specific QUAL approximations"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("VarDP", 1, VCFHeaderLineType.Integer, "(informative) depth over variant genotypes"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_VarDP", 1, VCFHeaderLineType.String, "Allele-specific (informative) depth over variant genotypes -- including ref, RAW format"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_AltDP", VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Allele-specific (informative) depth for alt alleles over variant genotypes; effectively sum of ADs"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("ReadPosRankSum", 1, VCFHeaderLineType.Float, "Z-score from Wilcoxon rank sum test of Alt vs. Ref read position bias"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_ReadPosRankSum", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "allele specific Z-score from Wilcoxon rank sum test of each Alt vs. Ref read position bias"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_RAW_ReadPosRankSum", 1, VCFHeaderLineType.String, "allele specific raw data for rank sum test of read position bias"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("Samples", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "List of polymorphic samples"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("SOR", 1, VCFHeaderLineType.Float, "Symmetric Odds Ratio of 2x2 contingency table to detect strand bias"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_SOR", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Allele specific strand Odds Ratio of 2x|Alts| contingency table to detect allele specific strand bias"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("STR", 0, VCFHeaderLineType.Flag, "Variant is a short tandem repeat"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("RU", 1, VCFHeaderLineType.String, "Tandem repeat unit (bases)"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("RPA", VCFHeaderLineCount.R, VCFHeaderLineType.Integer, "Number of times tandem repeat unit is repeated, for each allele (including reference)"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("NDA", 1, VCFHeaderLineType.Integer, "Number of alternate alleles discovered (but not necessarily genotyped) at this site"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AC_Orig", VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Original AC"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AF_Orig", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Original AF"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AN_Orig", 1, VCFHeaderLineType.Integer, "Original AN"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("DP_Orig", 1, VCFHeaderLineType.Integer, "Original DP"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("VQSLOD", 1, VCFHeaderLineType.Float, "Log odds of being a true variant versus being false under the trained gaussian mixture model"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("CNN_1D", 1, VCFHeaderLineType.Float, "Log odds of being a true variant versus being false under the trained 1D Convolutional Neural Network"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("CNN_2D", 1, VCFHeaderLineType.Float, "Log odds of being a true variant versus being false under the trained 2D Convolutional Neural Network"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("culprit", 1, VCFHeaderLineType.String, "The annotation which was the worst performing in the Gaussian mixture model, likely the reason why the variant was filtered out"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("POSITIVE_TRAIN_SITE", 1, VCFHeaderLineType.Flag, "This variant was used to build the positive training set of good variants"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("NEGATIVE_TRAIN_SITE", 1, VCFHeaderLineType.Flag, "This variant was used to build the negative training set of bad variants"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("callStatus", 1, VCFHeaderLineType.String, "Value from the validation VCF"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("IGC", 1, VCFHeaderLineType.Float, "GC Content of the interval"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("PG", VCFHeaderLineCount.G, VCFHeaderLineType.Integer, "Genotype Likelihood Prior"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("ECNT", 1, VCFHeaderLineType.Integer, "Number of events in this haplotype"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("NLOD", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Normal log 10 likelihood ratio of diploid het or hom alt genotypes"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("TLOD", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Log 10 likelihood ratio score of variant existing versus not existing"));
        GATKVCFHeaderLines.addFormatLine(new VCFFormatHeaderLine("TLOD", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Log 10 likelihood ratio score of variant existing versus not existing"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("PON", 0, VCFHeaderLineType.Flag, "site found in panel of normals"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("POPAF", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "negative log 10 population allele frequencies of alt alleles"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("GERMQ", 1, VCFHeaderLineType.Integer, "Phred-scaled quality that alt alleles are not germline variants"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("SEQQ", 1, VCFHeaderLineType.Integer, "Phred-scaled quality that alt alleles are not sequencing errors"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("STRQ", 1, VCFHeaderLineType.Integer, "Phred-scaled quality that alt alleles in STRs are not polymerase slippage errors"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("STRANDQ", 1, VCFHeaderLineType.Integer, "Phred-scaled quality of strand bias artifact"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("CONTQ", 1, VCFHeaderLineType.Float, "Phred-scaled qualities that alt allele are not due to contamination"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("ROQ", 1, VCFHeaderLineType.Float, "Phred-scaled qualities that alt allele are not due to read orientation artifact"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("NALOD", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Negative log 10 odds of artifact in normal with same allele fraction as tumor"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("OCM", 1, VCFHeaderLineType.Integer, "Number of alt reads whose original alignment doesn't match the current contig."));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("NCount", 1, VCFHeaderLineType.Integer, "Count of N bases in the pileup"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("AS_UNIQ_ALT_READ_COUNT", VCFHeaderLineCount.A, VCFHeaderLineType.Integer, "Number of reads with unique start and mate end positions for each alt at a variant site"));
        GATKVCFHeaderLines.addInfoLine(new BaseQuality().getDescriptions().get(0));
        GATKVCFHeaderLines.addInfoLine(new FragmentLength().getDescriptions().get(0));
        GATKVCFHeaderLines.addInfoLine(new MappingQuality().getDescriptions().get(0));
        GATKVCFHeaderLines.addInfoLine(new ReadPosition().getDescriptions().get(0));
        GATKVCFHeaderLines.addInfoLine(new AS_StrandBiasMutectAnnotation().getDescriptions().get(0));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("UNITIGS", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.Integer, "Sizes of reassembled unitigs"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("NALIGNS", 1, VCFHeaderLineType.Integer, "Number of joint alignments"));
        GATKVCFHeaderLines.addInfoLine(new VCFInfoHeaderLine("ALIGN_DIFF", 1, VCFHeaderLineType.Integer, "Difference in alignment score between best and next-best alignment"));
    }
}

