/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.variant;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.Locatable;
import htsjdk.utils.ValidationUtils;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.VariantContextUtils;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFSimpleHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.tools.walkers.annotator.AnnotationUtils;
import org.broadinstitute.hellbender.tools.walkers.annotator.allelespecific.StrandBiasUtils;
import org.broadinstitute.hellbender.tools.walkers.genotyper.AlleleSubsettingUtils;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeAlleleCounts;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeAssignmentMethod;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeLikelihoodCalculator;
import org.broadinstitute.hellbender.tools.walkers.genotyper.GenotypeLikelihoodCalculators;
import org.broadinstitute.hellbender.utils.BaseUtils;
import org.broadinstitute.hellbender.utils.IndexRange;
import org.broadinstitute.hellbender.utils.MathUtils;
import org.broadinstitute.hellbender.utils.Trilean;
import org.broadinstitute.hellbender.utils.Utils;
import org.broadinstitute.hellbender.utils.genotyper.GenotypePriorCalculator;
import org.broadinstitute.hellbender.utils.param.ParamUtils;
import org.broadinstitute.hellbender.utils.pileup.PileupElement;
import org.broadinstitute.hellbender.utils.read.AlignmentUtils;
import org.broadinstitute.hellbender.utils.variant.GATKVCFConstants;

public final class GATKVariantContextUtils {
    private static final Logger logger = LogManager.getLogger(GATKVariantContextUtils.class);
    public static final String MERGE_FILTER_PREFIX = "filterIn";
    public static final String MERGE_REF_IN_ALL = "ReferenceInAlln";
    public static final String MERGE_FILTER_IN_ALL = "FilteredInAll";
    public static final String MERGE_INTERSECTION = "Intersection";
    public static final int DEFAULT_PLOIDY = 2;
    private static final GenotypeLikelihoodCalculators GL_CALCS = new GenotypeLikelihoodCalculators();
    public static final double SUM_GL_THRESH_NOCALL = -0.1;
    @Deprecated
    public static final List<Allele> NO_CALL_ALLELES = Arrays.asList(Allele.NO_CALL, Allele.NO_CALL);
    private static List<Allele>[] NOCALL_LISTS = new List[]{Collections.emptyList(), Collections.singletonList(Allele.NO_CALL), Collections.nCopies(2, Allele.NO_CALL)};

    public static boolean isInformative(double[] gls) {
        return MathUtils.sum(gls) < -0.1;
    }

    public static Set<VCFHeaderLine> getDefaultVCFHeaderLines(String toolkitShortName, String toolName, String versionString, String dateTime, String cmdLine) {
        HashSet<VCFHeaderLine> defaultVCFHeaderLines = new HashSet<VCFHeaderLine>();
        HashMap<String, String> simpleHeaderLineMap = new HashMap<String, String>(4);
        simpleHeaderLineMap.put("ID", toolName);
        simpleHeaderLineMap.put("Version", versionString);
        simpleHeaderLineMap.put("Date", dateTime);
        simpleHeaderLineMap.put("CommandLine", cmdLine);
        defaultVCFHeaderLines.add(new VCFHeaderLine("source", toolName));
        defaultVCFHeaderLines.add((VCFHeaderLine)new VCFSimpleHeaderLine(String.format("%sCommandLine", toolkitShortName), simpleHeaderLineMap));
        return defaultVCFHeaderLines;
    }

    public static VariantContextWriter createVCFWriter(Path outPath, SAMSequenceDictionary referenceDictionary, boolean createMD5, Options ... options) {
        Utils.nonNull(outPath);
        VariantContextWriterBuilder vcWriterBuilder = new VariantContextWriterBuilder().clearOptions().setOutputPath(outPath);
        if (VariantContextWriterBuilder.OutputType.UNSPECIFIED == VariantContextWriterBuilder.determineOutputTypeFromFile((Path)outPath)) {
            logger.warn(String.format("Can't determine output variant file format from output file extension \"%s\". Defaulting to VCF.", FilenameUtils.getExtension((String)outPath.getFileName().toString())));
            vcWriterBuilder = vcWriterBuilder.setOutputFileType(VariantContextWriterBuilder.OutputType.VCF);
        }
        if (createMD5) {
            vcWriterBuilder.setCreateMD5();
        }
        if (null != referenceDictionary) {
            vcWriterBuilder = vcWriterBuilder.setReferenceDictionary(referenceDictionary);
        }
        for (Options opt : options) {
            vcWriterBuilder = vcWriterBuilder.setOption(opt);
        }
        return vcWriterBuilder.build();
    }

    private static boolean hasPLIncompatibleAlleles(Collection<Allele> alleleSet1, Collection<Allele> alleleSet2) {
        Iterator<Allele> it1 = alleleSet1.iterator();
        Iterator<Allele> it2 = alleleSet2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Allele a2;
            Allele a1 = it1.next();
            if (a1.equals((Object)(a2 = it2.next()))) continue;
            return true;
        }
        return it1.hasNext() || it2.hasNext();
    }

    public static boolean isAlleleInList(Allele ref1, Allele alt1, Allele ref2, List<Allele> altList) {
        if (ref1.equals((Object)ref2)) {
            return altList.contains(alt1);
        }
        Allele commonRef = GATKVariantContextUtils.determineReferenceAllele(ref1, ref2);
        if (ref1.equals((Object)commonRef)) {
            Map<Allele, Allele> alleleMap = GATKVariantContextUtils.createAlleleMapping(commonRef, ref2, altList);
            return alleleMap.values().contains(alt1);
        }
        if (ref2.equals((Object)commonRef)) {
            Map<Allele, Allele> alleleMap = GATKVariantContextUtils.createAlleleMapping(commonRef, ref1, Arrays.asList(alt1));
            return altList.contains(alleleMap.get(alt1));
        }
        throw new IllegalStateException("Reference alleles " + ref1 + " and " + ref2 + " have common reference allele " + commonRef + " which is equal to neither.");
    }

    public static Allele determineReferenceAllele(List<VariantContext> VCs, Locatable loc) {
        Allele ref = null;
        for (VariantContext vc : VCs) {
            if (!GATKVariantContextUtils.contextMatchesLoc(vc, loc)) continue;
            Allele myRef = vc.getReference();
            try {
                ref = GATKVariantContextUtils.determineReferenceAllele(ref, myRef);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(String.format("The provided variant file(s) have inconsistent references for the same position(s) at %s:%d, %s vs. %s", vc.getContig(), vc.getStart(), ref, myRef));
            }
        }
        return ref;
    }

    public static Allele determineReferenceAllele(Allele ref1, Allele ref2) {
        if (ref1 == null || ref1.length() < ref2.length()) {
            return ref2;
        }
        if (ref2 == null || ref2.length() < ref1.length()) {
            return ref1;
        }
        if (ref1.length() == ref2.length() && !ref1.equals((Object)ref2)) {
            throw new IllegalStateException(String.format("The provided reference alleles do not appear to represent the same position, %s vs. %s", ref1, ref2));
        }
        return ref1;
    }

    public static int totalPloidy(VariantContext vc, int defaultPloidy) {
        Utils.nonNull(vc, "the vc provided cannot be null");
        Utils.validateArg(defaultPloidy >= 0, "the default ploidy must 0 or greater");
        return vc.getGenotypes().stream().mapToInt(Genotype::getPloidy).map(p -> p <= 0 ? defaultPloidy : p).sum();
    }

    public static BaseUtils.BaseSubstitutionType getSNPSubstitutionType(VariantContext context) {
        Utils.nonNull(context);
        if (!context.isSNP() || !context.isBiallelic()) {
            throw new IllegalArgumentException("Requested SNP substitution type for bialleic non-SNP " + context);
        }
        return BaseUtils.SNPSubstitutionType(context.getReference().getBases()[0], context.getAlternateAllele(0).getBases()[0]);
    }

    public static boolean isTransition(VariantContext context) {
        Utils.nonNull(context);
        return GATKVariantContextUtils.getSNPSubstitutionType(context) == BaseUtils.BaseSubstitutionType.TRANSITION;
    }

    public static List<Allele> homozygousAlleleList(Allele allele, int ploidy) {
        Utils.nonNull(allele);
        Utils.validateArg(ploidy >= 0, "ploidy cannot be negative");
        return Collections.nCopies(ploidy, allele);
    }

    public static void makeGenotypeCall(int ploidy, GenotypeBuilder gb, GenotypeAssignmentMethod assignmentMethod, double[] genotypeLikelihoods, List<Allele> allelesToUse, List<Allele> originalGT, GenotypePriorCalculator gpc) {
        if (originalGT == null && assignmentMethod == GenotypeAssignmentMethod.BEST_MATCH_TO_ORIGINAL) {
            throw new IllegalArgumentException("original GT cannot be null if assignmentMethod is BEST_MATCH_TO_ORIGINAL");
        }
        if (assignmentMethod == GenotypeAssignmentMethod.SET_TO_NO_CALL) {
            gb.alleles(GATKVariantContextUtils.noCallAlleles(ploidy)).noGQ();
        } else if (assignmentMethod == GenotypeAssignmentMethod.USE_PLS_TO_ASSIGN) {
            if (genotypeLikelihoods == null || !GATKVariantContextUtils.isInformative(genotypeLikelihoods)) {
                gb.alleles(GATKVariantContextUtils.noCallAlleles(ploidy)).noGQ();
            } else {
                int maxLikelihoodIndex = MathUtils.maxElementIndex(genotypeLikelihoods);
                GenotypeLikelihoodCalculator glCalc = GL_CALCS.getInstance(ploidy, allelesToUse.size());
                GenotypeAlleleCounts alleleCounts = glCalc.genotypeAlleleCountsAt(maxLikelihoodIndex);
                List<Allele> finalAlleles = alleleCounts.asAlleleList(allelesToUse);
                if (finalAlleles.contains(Allele.NON_REF_ALLELE)) {
                    gb.alleles(GATKVariantContextUtils.noCallAlleles(ploidy));
                    gb.PL(new int[genotypeLikelihoods.length]);
                } else {
                    gb.alleles(finalAlleles);
                }
                int numAltAlleles = allelesToUse.size() - 1;
                if (numAltAlleles > 0) {
                    gb.log10PError(GenotypeLikelihoods.getGQLog10FromLikelihoods((int)maxLikelihoodIndex, (double[])genotypeLikelihoods));
                }
            }
        } else if (assignmentMethod == GenotypeAssignmentMethod.SET_TO_NO_CALL_NO_ANNOTATIONS) {
            gb.alleles(GATKVariantContextUtils.noCallAlleles(ploidy)).noGQ().noAD().noPL().noAttributes();
        } else if (assignmentMethod == GenotypeAssignmentMethod.BEST_MATCH_TO_ORIGINAL) {
            LinkedList<Allele> best = new LinkedList<Allele>();
            Allele ref = allelesToUse.get(0);
            for (Allele originalAllele : originalGT) {
                best.add(allelesToUse.contains(originalAllele) || originalAllele.isNoCall() ? originalAllele : ref);
            }
            gb.alleles(best);
        } else if (assignmentMethod == GenotypeAssignmentMethod.USE_POSTERIOR_PROBABILITIES) {
            if (gpc == null) {
                throw new GATKException("cannot uses posteriors without an genotype prior calculator present");
            }
            GenotypeLikelihoodCalculator glCalc = GL_CALCS.getInstance(ploidy, allelesToUse.size());
            double[] log10Priors = gpc.getLog10Priors(glCalc, allelesToUse);
            double[] log10Posteriors = MathUtils.ebeAdd(log10Priors, genotypeLikelihoods);
            double[] normalizedLog10Posteriors = MathUtils.scaleLogSpaceArrayForNumericalStability(log10Posteriors);
            gb.attribute("GP", (Object)Arrays.stream(normalizedLog10Posteriors).map(v -> v == 0.0 ? 0.0 : v * -10.0).mapToObj(GATKVariantContextUtils::formatGP).toArray());
            gb.attribute("PG", (Object)Arrays.stream(log10Priors).map(v -> v == 0.0 ? 0.0 : v * -10.0).mapToObj(GATKVariantContextUtils::formatGP).toArray());
            int maxPosteriorIndex = MathUtils.maxElementIndex(log10Posteriors);
            if (allelesToUse.size() > 0) {
                gb.log10PError(GATKVariantContextUtils.getGQLog10FromPosteriors(maxPosteriorIndex, normalizedLog10Posteriors));
            }
            gb.alleles(glCalc.genotypeAlleleCountsAt(maxPosteriorIndex).asAlleleList(allelesToUse));
        }
    }

    private static double getGQLog10FromPosteriors(int bestGenotypeIndex, double[] log10Posteriors) {
        if (bestGenotypeIndex < 0) {
            return 1.0;
        }
        switch (log10Posteriors.length) {
            case 0: 
            case 1: {
                return 1.0;
            }
            case 2: {
                return bestGenotypeIndex == 0 ? log10Posteriors[1] : log10Posteriors[0];
            }
            case 3: {
                return Math.min(0.0, MathUtils.log10SumLog10(log10Posteriors[bestGenotypeIndex == 0 ? 2 : bestGenotypeIndex - 1], log10Posteriors[bestGenotypeIndex == 2 ? 0 : bestGenotypeIndex + 1]));
            }
        }
        if (bestGenotypeIndex == 0) {
            return MathUtils.log10SumLog10(log10Posteriors, 1, log10Posteriors.length);
        }
        if (bestGenotypeIndex == log10Posteriors.length - 1) {
            return MathUtils.log10SumLog10(log10Posteriors, 0, bestGenotypeIndex);
        }
        return Math.min(0.0, MathUtils.log10SumLog10(MathUtils.log10sumLog10(log10Posteriors, 0, bestGenotypeIndex), MathUtils.log10sumLog10(log10Posteriors, bestGenotypeIndex + 1, log10Posteriors.length)));
    }

    private static String formatGP(double gp) {
        int last;
        String formatted = String.format("%.2f", gp);
        if (formatted.charAt(last = formatted.length() - 1) == '0') {
            if (formatted.charAt(--last) == '0') {
                return formatted.substring(0, --last);
            }
            return formatted.substring(0, ++last);
        }
        return formatted;
    }

    public static List<Allele> makePloidyLengthAlleleList(int ploidy, Allele allele) {
        if (ploidy == 0) {
            return Arrays.asList(Allele.NO_CALL);
        }
        ArrayList<Allele> repeatedList = new ArrayList<Allele>();
        for (int i = 0; i < ploidy; ++i) {
            repeatedList.add(allele);
        }
        return repeatedList;
    }

    public static void makeGenotypeCall(int ploidy, GenotypeBuilder gb, GenotypeAssignmentMethod assignmentMethod, double[] genotypeLikelihoods, List<Allele> allelesToUse, GenotypePriorCalculator gpc) {
        GATKVariantContextUtils.makeGenotypeCall(ploidy, gb, assignmentMethod, genotypeLikelihoods, allelesToUse, null, gpc);
    }

    public static VariantContext getOverlappingVariantContext(Locatable curPos, Collection<VariantContext> maybeOverlapping) {
        VariantContext overlaps = null;
        for (VariantContext vc : maybeOverlapping) {
            if (!curPos.overlaps((Locatable)vc) || overlaps != null && vc.getStart() <= overlaps.getStart()) continue;
            overlaps = vc;
        }
        return overlaps;
    }

    public static boolean isProperlyPolymorphic(VariantContext vc) {
        if (vc == null || vc.getAlternateAlleles().isEmpty()) {
            return false;
        }
        if (vc.isBiallelic()) {
            return !GATKVCFConstants.isSpanningDeletion(vc.getAlternateAllele(0)) && !vc.isSymbolic();
        }
        return !GATKVCFConstants.isSpanningDeletion(vc.getAlternateAllele(0)) || !vc.getAlternateAllele(1).equals((Object)Allele.NON_REF_ALLELE);
    }

    public static VariantContext.Type typeOfVariant(Allele ref, Allele allele) {
        Utils.nonNull(ref);
        Utils.nonNull(allele);
        if (ref.isSymbolic()) {
            throw new IllegalStateException("Unexpected error: encountered a record with a symbolic reference allele");
        }
        if (allele.isSymbolic()) {
            return VariantContext.Type.SYMBOLIC;
        }
        if (allele.equals((Object)Allele.SPAN_DEL)) {
            return VariantContext.Type.NO_VARIATION;
        }
        if (ref.equals((Object)Allele.SPAN_DEL)) {
            throw new IllegalStateException("Unexpected error: encountered a record with a spanning deletion reference allele");
        }
        if (ref.length() == allele.length()) {
            if (ref.basesMatch(allele)) {
                return VariantContext.Type.NO_VARIATION;
            }
            if (allele.length() == 1) {
                return VariantContext.Type.SNP;
            }
            if (IntStream.range(0, ref.length()).filter(i -> ref.getBases()[i] != allele.getBases()[i]).count() == 1L) {
                return VariantContext.Type.SNP;
            }
            return VariantContext.Type.MNP;
        }
        return VariantContext.Type.INDEL;
    }

    public static boolean isComplexIndel(Allele ref, Allele allele) {
        Utils.nonNull(ref);
        Utils.nonNull(allele);
        if (ref.isSymbolic() || ref.length() == 0) {
            return false;
        }
        if (allele.isSymbolic() || allele.length() == 0) {
            return false;
        }
        if (ref.length() == allele.length()) {
            return false;
        }
        if (allele.length() == 1 || ref.length() == 1) {
            return false;
        }
        if (allele.length() > ref.length()) {
            boolean isAltStartsWithRef = IntStream.range(0, ref.length()).allMatch(i -> ref.getBases()[i] == allele.getBases()[i]);
            return !isAltStartsWithRef;
        }
        boolean isRefStartsWithAlt = IntStream.range(0, allele.length()).allMatch(i -> ref.getBases()[i] == allele.getBases()[i]);
        return !isRefStartsWithAlt;
    }

    public static Allele chooseAlleleForRead(PileupElement pileupElement, Allele referenceAllele, List<Allele> altAlleles, int minBaseQualityCutoff) {
        Utils.nonNull(pileupElement);
        Utils.nonNull(referenceAllele);
        Utils.nonNull(altAlleles);
        ParamUtils.isPositiveOrZero(minBaseQualityCutoff, "Minimum base quality must be positive or zero.");
        boolean isRef = referenceAllele.basesMatch(GATKVariantContextUtils.getBasesForAlleleInRead(pileupElement, referenceAllele)) && !pileupElement.isBeforeDeletionStart() && !pileupElement.isBeforeInsertion();
        Allele pileupAllele = null;
        if (!isRef) {
            for (Allele altAllele : altAlleles) {
                VariantContext.Type variantType = GATKVariantContextUtils.typeOfVariant(referenceAllele, altAllele);
                if (variantType == VariantContext.Type.INDEL) {
                    if (!GATKVariantContextUtils.isIndelInThePileupElement(pileupElement, referenceAllele, altAllele)) continue;
                    pileupAllele = altAllele;
                    continue;
                }
                if (variantType != VariantContext.Type.MNP && variantType != VariantContext.Type.SNP || GATKVariantContextUtils.doesReadContainAllele(pileupElement, altAllele) != Trilean.TRUE) continue;
                pileupAllele = altAllele;
            }
        } else {
            pileupAllele = referenceAllele;
        }
        if (pileupAllele != null && GATKVariantContextUtils.getMinBaseQualityForAlleleInRead(pileupElement, pileupAllele) < minBaseQualityCutoff) {
            pileupAllele = null;
        }
        return pileupAllele;
    }

    private static boolean isIndelInThePileupElement(PileupElement pileupElement, Allele referenceAllele, Allele altAllele) {
        boolean isAltAlleleInThePileup = false;
        if (pileupElement.isBeforeInsertion()) {
            String insertionBases = pileupElement.getBasesOfImmediatelyFollowingInsertion();
            if (insertionBases != null && Allele.extend((Allele)referenceAllele, (byte[])insertionBases.getBytes()).basesMatch(altAllele)) {
                isAltAlleleInThePileup = true;
            }
        } else if (pileupElement.isBeforeDeletionStart()) {
            int deletionLength = pileupElement.getLengthOfImmediatelyFollowingIndel();
            if (referenceAllele.getBases().length - altAllele.getBases().length == deletionLength) {
                isAltAlleleInThePileup = true;
            }
        }
        return isAltAlleleInThePileup;
    }

    private static byte[] getBasesForAlleleInRead(PileupElement pileupElement, Allele allele) {
        Utils.nonNull(pileupElement);
        Utils.nonNull(allele);
        return ArrayUtils.subarray((byte[])pileupElement.getRead().getBases(), (int)pileupElement.getOffset(), (int)(pileupElement.getOffset() + allele.getBases().length));
    }

    public static Trilean doesReadContainAllele(PileupElement pileupElement, Allele allele) {
        Utils.nonNull(pileupElement);
        Utils.nonNull(allele);
        byte[] readBases = ArrayUtils.subarray((byte[])pileupElement.getRead().getBases(), (int)pileupElement.getOffset(), (int)(pileupElement.getOffset() + allele.getBases().length));
        if (readBases.length < allele.getBases().length) {
            return Trilean.UNKNOWN;
        }
        if (allele.basesMatch(readBases)) {
            return Trilean.TRUE;
        }
        return Trilean.FALSE;
    }

    private static int getMinBaseQualityForAlleleInRead(PileupElement pileupElement, Allele allele) {
        Utils.nonNull(pileupElement);
        Utils.nonNull(allele);
        byte[] alleleBases = allele.getBases();
        byte[] pileupBaseQualities = ArrayUtils.subarray((byte[])pileupElement.getRead().getBaseQualities(), (int)pileupElement.getOffset(), (int)(pileupElement.getOffset() + alleleBases.length));
        OptionalInt minQuality = IntStream.range(0, pileupBaseQualities.length).map(i -> Byte.toUnsignedInt(pileupBaseQualities[i])).min();
        return minQuality.orElse(-1);
    }

    public static boolean containsInlineIndel(VariantContext vc) {
        List alleles = vc.getAlleles();
        int refLength = ((Allele)alleles.get(0)).length();
        for (int i = 1; i < alleles.size(); ++i) {
            Allele alt = (Allele)alleles.get(i);
            if (alt.isSymbolic() || alt == Allele.SPAN_DEL || alt.length() == refLength) continue;
            return true;
        }
        return false;
    }

    public static boolean isTandemRepeat(VariantContext vc, byte[] refBasesStartingAtVCWithPad) {
        String refBasesStartingAtVCWithoutPad = new String(refBasesStartingAtVCWithPad).substring(1);
        if (!vc.isIndel()) {
            return false;
        }
        Allele ref = vc.getReference();
        for (Allele allele : vc.getAlternateAlleles()) {
            if (GATKVariantContextUtils.isRepeatAllele(ref, allele, refBasesStartingAtVCWithoutPad)) continue;
            return false;
        }
        return true;
    }

    public static Pair<List<Integer>, byte[]> getNumTandemRepeatUnits(VariantContext vc, byte[] refBasesStartingAtVCWithoutPad) {
        Utils.nonNull(vc);
        Utils.nonNull(refBasesStartingAtVCWithoutPad);
        if (!vc.isIndel()) {
            return null;
        }
        Allele refAllele = vc.getReference();
        byte[] refAlleleBases = Arrays.copyOfRange(refAllele.getBases(), 1, refAllele.length());
        byte[] repeatUnit = null;
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        for (Allele allele : vc.getAlternateAlleles()) {
            Pair<int[], byte[]> result = GATKVariantContextUtils.getNumTandemRepeatUnits(refAlleleBases, Arrays.copyOfRange(allele.getBases(), 1, allele.length()), refBasesStartingAtVCWithoutPad);
            int[] repetitionCount = (int[])result.getLeft();
            if (repetitionCount[0] == 0 || repetitionCount[1] == 0) {
                return null;
            }
            if (lengths.isEmpty()) {
                lengths.add(repetitionCount[0]);
            }
            lengths.add(repetitionCount[1]);
            repeatUnit = (byte[])result.getRight();
        }
        return new MutablePair(lengths, repeatUnit);
    }

    public static Pair<int[], byte[]> getNumTandemRepeatUnits(byte[] refBases, byte[] altBases, byte[] remainingRefContext) {
        byte[] longB = altBases.length > refBases.length ? altBases : refBases;
        int repeatUnitLength = GATKVariantContextUtils.findRepeatedSubstring(longB);
        byte[] repeatUnit = Arrays.copyOf(longB, repeatUnitLength);
        int[] repetitionCount = new int[2];
        int repetitionsInRef = GATKVariantContextUtils.findNumberOfRepetitions(repeatUnit, refBases, true);
        repetitionCount[0] = GATKVariantContextUtils.findNumberOfRepetitions(repeatUnit, ArrayUtils.addAll((byte[])refBases, (byte[])remainingRefContext), true) - repetitionsInRef;
        repetitionCount[1] = GATKVariantContextUtils.findNumberOfRepetitions(repeatUnit, ArrayUtils.addAll((byte[])altBases, (byte[])remainingRefContext), true) - repetitionsInRef;
        return new MutablePair((Object)repetitionCount, (Object)repeatUnit);
    }

    public static int findRepeatedSubstring(byte[] bases) {
        int repLength;
        for (repLength = 1; repLength <= bases.length; ++repLength) {
            byte[] candidateRepeatUnit = Arrays.copyOf(bases, repLength);
            boolean allBasesMatch = true;
            for (int start = repLength; start < bases.length; start += repLength) {
                byte[] basePiece = Arrays.copyOfRange(bases, start, start + candidateRepeatUnit.length);
                if (Arrays.equals(candidateRepeatUnit, basePiece)) continue;
                allBasesMatch = false;
                break;
            }
            if (!allBasesMatch) continue;
            return repLength;
        }
        return repLength;
    }

    public static int findNumberOfRepetitions(byte[] repeatUnit, byte[] testString, boolean leadingRepeats) {
        Utils.nonNull(repeatUnit, "repeatUnit");
        Utils.nonNull(testString, "testString");
        Utils.validateArg(repeatUnit.length != 0, "empty repeatUnit");
        if (testString.length == 0) {
            return 0;
        }
        return GATKVariantContextUtils.findNumberOfRepetitions(repeatUnit, 0, repeatUnit.length, testString, 0, testString.length, leadingRepeats);
    }

    public static int findNumberOfRepetitions(byte[] repeatUnitFull, int offsetInRepeatUnitFull, int repeatUnitLength, byte[] testStringFull, int offsetInTestStringFull, int testStringLength, boolean leadingRepeats) {
        Utils.nonNull(repeatUnitFull, "repeatUnit");
        Utils.nonNull(testStringFull, "testString");
        Utils.validIndex(offsetInRepeatUnitFull, repeatUnitFull.length);
        Utils.validateArg(repeatUnitLength >= 0 && repeatUnitLength <= repeatUnitFull.length, "repeatUnitLength");
        if (testStringLength == 0) {
            return 0;
        }
        Utils.validIndex(offsetInTestStringFull, testStringFull.length);
        Utils.validateArg(testStringLength >= 0 && testStringLength <= testStringFull.length, "testStringLength");
        int lengthDifference = testStringLength - repeatUnitLength;
        if (leadingRepeats) {
            int numRepeats = 0;
            for (int start = 0; start <= lengthDifference; start += repeatUnitLength) {
                if (Utils.equalRange(testStringFull, start + offsetInTestStringFull, repeatUnitFull, offsetInRepeatUnitFull, repeatUnitLength)) {
                    ++numRepeats;
                    continue;
                }
                return numRepeats;
            }
            return numRepeats;
        }
        int numRepeats = 0;
        for (int start = lengthDifference; start >= 0; start -= repeatUnitLength) {
            if (Utils.equalRange(testStringFull, start + offsetInTestStringFull, repeatUnitFull, offsetInRepeatUnitFull, repeatUnitLength)) {
                ++numRepeats;
                continue;
            }
            return numRepeats;
        }
        return numRepeats;
    }

    protected static boolean isRepeatAllele(Allele ref, Allele alt, String refBasesStartingAtVCWithoutPad) {
        if (!Allele.oneIsPrefixOfOther((Allele)ref, (Allele)alt)) {
            return false;
        }
        if (ref.length() > alt.length()) {
            return GATKVariantContextUtils.basesAreRepeated(ref.getBaseString(), alt.getBaseString(), refBasesStartingAtVCWithoutPad, 2);
        }
        return GATKVariantContextUtils.basesAreRepeated(alt.getBaseString(), ref.getBaseString(), refBasesStartingAtVCWithoutPad, 1);
    }

    protected static boolean basesAreRepeated(String l, String s, String ref, int minNumberOfMatches) {
        String potentialRepeat = l.substring(s.length());
        for (int i = 0; i < minNumberOfMatches; ++i) {
            int start = i * potentialRepeat.length();
            int end = (i + 1) * potentialRepeat.length();
            if (ref.length() < end) {
                return false;
            }
            String refSub = ref.substring(start, end);
            if (refSub.equals(potentialRepeat)) continue;
            return false;
        }
        return true;
    }

    public static GenotypesContext subsetToRefOnly(VariantContext vc, int defaultPloidy) {
        Utils.nonNull(Boolean.valueOf(vc == null), "vc cannot be null");
        Utils.validateArg(defaultPloidy >= 1, () -> "defaultPloidy must be >= 1 but got " + defaultPloidy);
        GenotypesContext oldGTs = vc.getGenotypes();
        if (oldGTs.isEmpty()) {
            return oldGTs;
        }
        GenotypesContext newGTs = GenotypesContext.create((int)oldGTs.size());
        Allele ref = vc.getReference();
        List<Allele> diploidRefAlleles = Arrays.asList(ref, ref);
        for (Genotype g : vc.getGenotypes()) {
            int gPloidy = g.getPloidy() == 0 ? defaultPloidy : g.getPloidy();
            List<Allele> refAlleles = gPloidy == 2 ? diploidRefAlleles : Collections.nCopies(gPloidy, ref);
            GenotypeBuilder gb = new GenotypeBuilder(g.getSampleName(), refAlleles);
            if (g.hasDP()) {
                gb.DP(g.getDP());
            }
            if (g.hasGQ()) {
                gb.GQ(g.getGQ());
            }
            newGTs.add(gb.make());
        }
        return newGTs;
    }

    public static Genotype removePLsAndAD(Genotype g) {
        return g.hasLikelihoods() || g.hasAD() ? new GenotypeBuilder(g).noPL().noAD().make() : g;
    }

    public static VariantContext simpleMerge(Collection<VariantContext> unsortedVCs, List<String> priorityListOfVCs, FilteredRecordMergeType filteredRecordMergeType, GenotypeMergeType genotypeMergeOptions, boolean filteredAreUncalled) {
        int originalNumOfVCs = priorityListOfVCs == null ? 0 : priorityListOfVCs.size();
        return GATKVariantContextUtils.simpleMerge(unsortedVCs, priorityListOfVCs, originalNumOfVCs, filteredRecordMergeType, genotypeMergeOptions, filteredAreUncalled);
    }

    public static VariantContext simpleMerge(Collection<VariantContext> unsortedVCs, List<String> priorityListOfVCs, int originalNumOfVCs, FilteredRecordMergeType filteredRecordMergeType, GenotypeMergeType genotypeMergeOptions, boolean filteredAreUncalled) {
        if (unsortedVCs == null || unsortedVCs.isEmpty()) {
            return null;
        }
        if (priorityListOfVCs != null && originalNumOfVCs != priorityListOfVCs.size()) {
            throw new IllegalArgumentException("the number of the original VariantContexts must be the same as the number of VariantContexts in the priority list");
        }
        List<VariantContext> preFilteredVCs = GATKVariantContextUtils.sortVariantContextsByPriority(unsortedVCs, priorityListOfVCs, genotypeMergeOptions);
        List<VariantContext> VCs = preFilteredVCs.stream().filter(vc -> !filteredAreUncalled || vc.isNotFiltered()).collect(Collectors.toList());
        if (VCs.isEmpty()) {
            return null;
        }
        VariantContext first = (VariantContext)VCs.get(0);
        String name = first.getSource();
        Allele refAllele = GATKVariantContextUtils.determineReferenceAllele(VCs);
        LinkedHashSet<Allele> alleles = new LinkedHashSet<Allele>();
        LinkedHashSet filters = new LinkedHashSet();
        LinkedHashMap attributes = new LinkedHashMap();
        LinkedHashSet<String> inconsistentAttributes = new LinkedHashSet<String>();
        LinkedHashSet<String> variantSources = new LinkedHashSet<String>();
        LinkedHashSet<String> rsIDs = new LinkedHashSet<String>(1);
        VariantContext longestVC = first;
        int depth = 0;
        double log10PError = 1.0;
        boolean anyVCHadFiltersApplied = false;
        GenotypesContext genotypes = GenotypesContext.create();
        int nFiltered = 0;
        for (VariantContext vc2 : VCs) {
            Utils.validate(longestVC.getStart() == vc2.getStart(), () -> "BUG: attempting to merge VariantContexts with different start sites: first=" + first.toString() + " second=" + vc2.toString());
            if (VariantContextUtils.getSize((VariantContext)vc2) > VariantContextUtils.getSize((VariantContext)longestVC)) {
                longestVC = vc2;
            }
            nFiltered += vc2.isFiltered() ? 1 : 0;
            if (vc2.isVariant()) {
                variantSources.add(vc2.getSource());
            }
            AlleleMapper alleleMapping = GATKVariantContextUtils.resolveIncompatibleAlleles(refAllele, vc2);
            alleles.addAll(alleleMapping.values());
            GATKVariantContextUtils.mergeGenotypes(genotypes, vc2, alleleMapping, genotypeMergeOptions == GenotypeMergeType.UNIQUIFY);
            if (log10PError == 1.0) {
                log10PError = vc2.getLog10PError();
            }
            filters.addAll(vc2.getFilters());
            anyVCHadFiltersApplied |= vc2.filtersWereApplied();
            if (vc2.hasAttribute("DP")) {
                depth += vc2.getAttributeAsInt("DP", 0);
            }
            if (vc2.hasID()) {
                rsIDs.add(vc2.getID());
            }
            for (Map.Entry p : vc2.getAttributes().entrySet()) {
                boolean boundIsMissingValue;
                String key = (String)p.getKey();
                Object value = p.getValue();
                if (inconsistentAttributes.contains(key)) continue;
                boolean alreadyFound = attributes.containsKey(key);
                Object boundValue = attributes.get(key);
                boolean bl = boundIsMissingValue = alreadyFound && boundValue.equals(".");
                if (alreadyFound && !boundValue.equals(value) && !boundIsMissingValue) {
                    inconsistentAttributes.add(key);
                    attributes.remove(key);
                    continue;
                }
                if (alreadyFound && !boundIsMissingValue) continue;
                attributes.put(key, value);
            }
        }
        for (VariantContext vc2 : VCs) {
            if (vc2.getAlleles().size() == 1 || !GATKVariantContextUtils.hasPLIncompatibleAlleles(alleles, vc2.getAlleles())) continue;
            if (!genotypes.isEmpty()) {
                logger.debug(String.format("Stripping PLs at %s:%d-%d due to incompatible alleles merged=%s vs. single=%s", vc2.getContig(), vc2.getStart(), vc2.getEnd(), alleles, vc2.getAlleles()));
            }
            genotypes = GATKVariantContextUtils.stripPLsAndAD(genotypes);
            VariantContextUtils.calculateChromosomeCounts((VariantContext)vc2, attributes, (boolean)true);
            break;
        }
        if (filteredRecordMergeType == FilteredRecordMergeType.KEEP_IF_ANY_UNFILTERED && nFiltered != VCs.size() || filteredRecordMergeType == FilteredRecordMergeType.KEEP_UNCONDITIONAL) {
            filters.clear();
        }
        if (depth > 0) {
            attributes.put("DP", String.valueOf(depth));
        }
        String ID = rsIDs.isEmpty() ? "." : Utils.join(",", rsIDs);
        VariantContextBuilder builder = new VariantContextBuilder().source(name).id(ID);
        builder.loc(longestVC.getContig(), (long)longestVC.getStart(), (long)longestVC.getEnd());
        builder.alleles(alleles);
        builder.genotypes(genotypes);
        builder.log10PError(log10PError);
        if (anyVCHadFiltersApplied) {
            builder.filters(filters.isEmpty() ? filters : new TreeSet(filters));
        }
        builder.attributes(new TreeMap(attributes));
        VariantContext merged = builder.make();
        return merged;
    }

    public static GenotypesContext stripPLsAndAD(GenotypesContext genotypes) {
        GenotypesContext newGs = GenotypesContext.create((int)genotypes.size());
        for (Genotype g : genotypes) {
            newGs.add(GATKVariantContextUtils.removePLsAndAD(g));
        }
        return newGs;
    }

    private static Allele determineReferenceAllele(List<VariantContext> VCs) {
        return GATKVariantContextUtils.determineReferenceAllele(VCs, null);
    }

    public static boolean contextMatchesLoc(VariantContext vc, Locatable loc) {
        return loc == null || loc.getStart() == vc.getStart();
    }

    public static AlleleMapper resolveIncompatibleAlleles(Allele refAllele, VariantContext vc) {
        if (refAllele.equals((Object)vc.getReference())) {
            return new AlleleMapper(vc);
        }
        Map<Allele, Allele> map = GATKVariantContextUtils.createAlleleMapping(refAllele, vc);
        map.put(vc.getReference(), refAllele);
        return new AlleleMapper(map);
    }

    public static Map<Allele, Allele> createAlleleMapping(Allele refAllele, VariantContext oneVC) {
        return GATKVariantContextUtils.createAlleleMapping(refAllele, oneVC.getReference(), oneVC.getAlternateAlleles());
    }

    public static Map<Allele, Allele> createAlleleMapping(Allele refAllele, Allele inputRef, List<Allele> inputAlts) {
        Utils.validate(refAllele.length() > inputRef.length(), () -> "BUG: inputRef=" + inputRef + " is longer than refAllele=" + refAllele);
        byte[] extraBases = Arrays.copyOfRange(refAllele.getBases(), inputRef.length(), refAllele.length());
        LinkedHashMap<Allele, Allele> map = new LinkedHashMap<Allele, Allele>();
        for (Allele a : inputAlts) {
            if (GATKVariantContextUtils.isNonSymbolicExtendableAllele(a)) {
                Allele extended = Allele.extend((Allele)a, (byte[])extraBases);
                map.put(a, extended);
                continue;
            }
            if (!a.equals((Object)Allele.SPAN_DEL)) continue;
            map.put(a, a);
        }
        return map;
    }

    private static boolean isNonSymbolicExtendableAllele(Allele allele) {
        return !allele.isReference() && !allele.isSymbolic() && !allele.equals((Object)Allele.SPAN_DEL);
    }

    public static List<VariantContext> sortVariantContextsByPriority(Collection<VariantContext> unsortedVCs, List<String> priorityListOfVCs, GenotypeMergeType mergeOption) {
        if (mergeOption == GenotypeMergeType.PRIORITIZE && priorityListOfVCs == null) {
            throw new IllegalArgumentException("Cannot merge calls by priority with a null priority list");
        }
        if (priorityListOfVCs == null || mergeOption == GenotypeMergeType.UNSORTED) {
            return new ArrayList<VariantContext>(unsortedVCs);
        }
        ArrayList<VariantContext> sorted = new ArrayList<VariantContext>(unsortedVCs);
        Collections.sort(sorted, new CompareByPriority(priorityListOfVCs));
        return sorted;
    }

    private static void mergeGenotypes(GenotypesContext mergedGenotypes, VariantContext oneVC, AlleleMapper alleleMapping, boolean uniquifySamples) {
        for (Genotype g : oneVC.getGenotypes()) {
            String name = GATKVariantContextUtils.mergedSampleName(oneVC.getSource(), g.getSampleName(), uniquifySamples);
            if (mergedGenotypes.containsSample(name)) continue;
            Genotype newG = g;
            if (uniquifySamples || alleleMapping.needsRemapping()) {
                List<Allele> alleles = alleleMapping.needsRemapping() ? alleleMapping.remap(g.getAlleles()) : g.getAlleles();
                newG = new GenotypeBuilder(g).name(name).alleles(alleles).make();
            }
            mergedGenotypes.add(newG);
        }
    }

    private static void ensureNoCallListsCapacity(int capacity) {
        int currentCapacity = NOCALL_LISTS.length - 1;
        if (currentCapacity >= capacity) {
            return;
        }
        NOCALL_LISTS = Arrays.copyOf(NOCALL_LISTS, Math.max(capacity, currentCapacity << 1) + 1);
        for (int i = currentCapacity + 1; i < NOCALL_LISTS.length; ++i) {
            GATKVariantContextUtils.NOCALL_LISTS[i] = Collections.nCopies(i, Allele.NO_CALL);
        }
    }

    public static List<Allele> noCallAlleles(int ploidy) {
        if (NOCALL_LISTS.length <= ploidy) {
            GATKVariantContextUtils.ensureNoCallListsCapacity(ploidy);
        }
        return NOCALL_LISTS[ploidy];
    }

    public static String mergedSampleName(String trackName, String sampleName, boolean uniquify) {
        return uniquify ? sampleName + "." + trackName : sampleName;
    }

    public static VariantContext reverseTrimAlleles(VariantContext inputVC) {
        return GATKVariantContextUtils.trimAlleles(inputVC, false, true);
    }

    public static VariantContext trimAlleles(VariantContext inputVC, boolean trimForward, boolean trimReverse) {
        Utils.nonNull(inputVC);
        if (inputVC.getNAlleles() <= 1 || inputVC.getAlleles().stream().anyMatch(a -> a.length() == 1)) {
            return inputVC;
        }
        List<byte[]> sequences = inputVC.getAlleles().stream().filter(a -> !a.isSymbolic()).map(Allele::getBases).collect(Collectors.toList());
        List<IndexRange> ranges = inputVC.getAlleles().stream().filter(a -> !a.isSymbolic()).map(a -> new IndexRange(0, a.length())).collect(Collectors.toList());
        Pair<Integer, Integer> shifts = AlignmentUtils.normalizeAlleles(sequences, ranges, 0, true);
        int endTrim = (Integer)shifts.getRight();
        int startTrim = -((Integer)shifts.getLeft()).intValue();
        boolean emptyAllele = ranges.stream().anyMatch(r -> r.size() == 0);
        boolean restoreOneBaseAtEnd = emptyAllele && startTrim == 0;
        boolean restoreOneBaseAtStart = emptyAllele && startTrim > 0;
        int endBasesToClip = restoreOneBaseAtEnd ? endTrim - 1 : endTrim;
        int startBasesToClip = restoreOneBaseAtStart ? startTrim - 1 : startTrim;
        return GATKVariantContextUtils.trimAlleles(inputVC, (trimForward ? startBasesToClip : 0) - 1, trimReverse ? endBasesToClip : 0);
    }

    protected static VariantContext trimAlleles(VariantContext inputVC, int fwdTrimEnd, int revTrim) {
        if (fwdTrimEnd == -1 && revTrim == 0) {
            return inputVC;
        }
        LinkedList<Allele> alleles = new LinkedList<Allele>();
        LinkedHashMap<Allele, Allele> originalToTrimmedAlleleMap = new LinkedHashMap<Allele, Allele>();
        for (Allele a : inputVC.getAlleles()) {
            if (a.isSymbolic()) {
                alleles.add(a);
                originalToTrimmedAlleleMap.put(a, a);
                continue;
            }
            byte[] newBases = Arrays.copyOfRange(a.getBases(), fwdTrimEnd + 1, a.length() - revTrim);
            Allele trimmedAllele = Allele.create((byte[])newBases, (boolean)a.isReference());
            alleles.add(trimmedAllele);
            originalToTrimmedAlleleMap.put(a, trimmedAllele);
        }
        AlleleMapper alleleMapper = new AlleleMapper(originalToTrimmedAlleleMap);
        GenotypesContext genotypes = GATKVariantContextUtils.updateGenotypesWithMappedAlleles(inputVC.getGenotypes(), alleleMapper);
        int start = inputVC.getStart() + (fwdTrimEnd + 1);
        VariantContextBuilder builder = new VariantContextBuilder(inputVC);
        builder.start((long)start);
        builder.stop((long)(start + ((Allele)alleles.get(0)).length() - 1));
        builder.alleles(alleles);
        builder.genotypes(genotypes);
        return builder.make();
    }

    protected static GenotypesContext updateGenotypesWithMappedAlleles(GenotypesContext originalGenotypes, AlleleMapper alleleMapper) {
        GenotypesContext updatedGenotypes = GenotypesContext.create((int)originalGenotypes.size());
        for (Genotype genotype : originalGenotypes) {
            List<Allele> updatedAlleles = alleleMapper.remap(genotype.getAlleles());
            updatedGenotypes.add(new GenotypeBuilder(genotype).alleles(updatedAlleles).make());
        }
        return updatedGenotypes;
    }

    public static VariantContext makeFromAlleles(String name, String contig, int start, List<String> alleleStrings) {
        Utils.nonNull(alleleStrings, "alleleStrings is null");
        Utils.nonEmpty(alleleStrings, "alleleStrings is empty");
        LinkedList<Allele> alleles = new LinkedList<Allele>();
        int length = alleleStrings.get(0).length();
        boolean first = true;
        for (String alleleString : alleleStrings) {
            alleles.add(Allele.create((String)alleleString, (boolean)first));
            first = false;
        }
        return new VariantContextBuilder(name, contig, (long)start, (long)(start + length - 1), alleles).make();
    }

    public static List<VariantContext> splitSomaticVariantContextToBiallelics(VariantContext vc, boolean trimLeft, VCFHeader outputHeader) {
        Utils.nonNull(vc);
        if (!vc.isVariant() || vc.isBiallelic()) {
            return Collections.singletonList(vc);
        }
        LinkedList<VariantContext> biallelics = new LinkedList<VariantContext>();
        ArrayList<String> attrsSpecialFormats = new ArrayList<String>(Arrays.asList("AS_FilterStatus", "AS_SB_TABLE"));
        List<Map<String, Object>> attributesByAllele = GATKVariantContextUtils.splitAttributesIntoPerAlleleLists(vc, attrsSpecialFormats, outputHeader);
        GATKVariantContextUtils.splitASSBTable(vc, attributesByAllele);
        GATKVariantContextUtils.splitASFilters(vc, attributesByAllele);
        ListIterator<Map<String, Object>> attributesByAlleleIterator = attributesByAllele.listIterator();
        for (Allele alt : vc.getAlternateAlleles()) {
            VariantContextBuilder builder = new VariantContextBuilder(vc);
            List<Allele> alleles = Arrays.asList(vc.getReference(), alt);
            builder.alleles(alleles);
            Map<String, Object> attributes = attributesByAlleleIterator.next();
            builder.attributes(attributes);
            String filters = (String)attributes.get("AS_FilterStatus");
            if (!(filters == null || filters.isEmpty() || filters.equals(".") || filters.equals("SITE") || filters.equals("PASS"))) {
                AnnotationUtils.decodeAnyASList(filters).stream().forEach(filter -> builder.filter(filter));
            }
            int alleleIndex = vc.getAlleleIndex(alt);
            builder.genotypes(AlleleSubsettingUtils.subsetSomaticAlleles(outputHeader, vc.getGenotypes(), alleles, new int[]{0, alleleIndex}));
            VariantContext trimmed = GATKVariantContextUtils.trimAlleles(builder.make(), trimLeft, true);
            biallelics.add(trimmed);
        }
        return biallelics;
    }

    public static void splitASSBTable(VariantContext vc, List<Map<String, Object>> attrsByAllele) {
        List sbs = StrandBiasUtils.getSBsForAlleles(vc).stream().map(ints -> StrandBiasUtils.encode(ints)).collect(Collectors.toList());
        new IndexRange(1, sbs.size()).forEach(i -> {
            String newattrs = String.join((CharSequence)"|", new ArrayList<String>(Arrays.asList((String)sbs.get(0), (String)sbs.get(i))));
            ((Map)attrsByAllele.get(i - 1)).put("AS_SB_TABLE", newattrs);
        });
    }

    public static void splitASFilters(VariantContext vc, List<Map<String, Object>> attrsByAllele) {
        String asfiltersStr = String.join((CharSequence)",", vc.getCommonInfo().getAttributeAsStringList("AS_FilterStatus", "SITE"));
        List<String> filtersList = AnnotationUtils.decodeAnyASListWithRawDelim(asfiltersStr);
        new IndexRange(0, filtersList.size()).forEach(i -> ((Map)attrsByAllele.get(i)).put("AS_FilterStatus", filtersList.get(i)));
    }

    public static List<Map<String, Object>> splitAttributesIntoPerAlleleLists(VariantContext vc, List<String> skipAttributes, VCFHeader outputHeader) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>(vc.getNAlleles() - 1);
        vc.getAlternateAlleles().forEach(alt -> results.add(new HashMap()));
        Map attributes = vc.getAttributes();
        attributes.entrySet().stream().filter(entry -> !skipAttributes.contains(entry.getKey())).forEachOrdered(entry -> {
            String key = (String)entry.getKey();
            VCFHeaderLineCount countType = VCFHeaderLineCount.UNBOUNDED;
            try {
                VCFInfoHeaderLine header = outputHeader.getInfoHeaderLine(key);
                countType = header.getCountType();
            }
            catch (IllegalStateException ex) {
                logger.warn("Could not find header info for key " + key);
            }
            if (key.equals("RPA")) {
                countType = VCFHeaderLineCount.R;
            }
            switch (countType) {
                case A: {
                    List attr = vc.getCommonInfo().getAttributeAsList(key);
                    ValidationUtils.validateArg((attr.size() == results.size() ? 1 : 0) != 0, (String)("Incorrect attribute size for " + key));
                    new IndexRange(0, attr.size()).forEach(i -> ((Map)results.get(i)).put(key, attr.get(i)));
                    break;
                }
                case R: {
                    List attr = vc.getCommonInfo().getAttributeAsList(key);
                    ValidationUtils.validateArg((attr.size() == vc.getNAlleles() ? 1 : 0) != 0, (String)("Incorrect attribute size for " + key));
                    new IndexRange(1, attr.size()).forEach(i -> {
                        ArrayList<Object> newattrs = new ArrayList<Object>(Arrays.asList(attr.get(0), attr.get(i)));
                        ((Map)results.get(i - 1)).put(key, newattrs);
                    });
                    break;
                }
                default: {
                    results.forEach(altMap -> altMap.put(key, entry.getValue()));
                }
            }
        });
        return results;
    }

    public static List<VariantContext> splitVariantContextToBiallelics(VariantContext vc, boolean trimLeft, GenotypeAssignmentMethod genotypeAssignmentMethod, boolean keepOriginalChrCounts) {
        Utils.nonNull(vc);
        if (!vc.isVariant() || vc.isBiallelic()) {
            return Collections.singletonList(vc);
        }
        LinkedList<VariantContext> biallelics = new LinkedList<VariantContext>();
        GenotypeAssignmentMethod genotypeAssignmentMethodUsed = GATKVariantContextUtils.hasHetNonRef(vc.getGenotypes()) ? GenotypeAssignmentMethod.SET_TO_NO_CALL_NO_ANNOTATIONS : genotypeAssignmentMethod;
        for (Allele alt : vc.getAlternateAlleles()) {
            VariantContextBuilder builder = new VariantContextBuilder(vc);
            List<Allele> alleles = Arrays.asList(vc.getReference(), alt);
            builder.alleles(alleles);
            for (String key : vc.getAttributes().keySet()) {
                if ((key.equals("AC") || key.equals("AF") || key.equals("AN")) && genotypeAssignmentMethodUsed != GenotypeAssignmentMethod.SET_TO_NO_CALL_NO_ANNOTATIONS) continue;
                builder.rmAttribute(key);
            }
            if (genotypeAssignmentMethodUsed != GenotypeAssignmentMethod.SET_TO_NO_CALL_NO_ANNOTATIONS && genotypeAssignmentMethodUsed != GenotypeAssignmentMethod.SET_TO_NO_CALL) {
                AlleleSubsettingUtils.addInfoFieldAnnotations(vc, builder, keepOriginalChrCounts);
            }
            builder.genotypes(AlleleSubsettingUtils.subsetAlleles(vc.getGenotypes(), 2, vc.getAlleles(), alleles, null, genotypeAssignmentMethodUsed, vc.getAttributeAsInt("DP", 0)));
            VariantContext trimmed = GATKVariantContextUtils.trimAlleles(builder.make(), trimLeft, true);
            biallelics.add(trimmed);
        }
        return biallelics;
    }

    private static boolean hasHetNonRef(GenotypesContext genotypesContext) {
        for (Genotype gt : genotypesContext) {
            if (!gt.isHetNonRef()) continue;
            return true;
        }
        return false;
    }

    public static List<VariantContext> splitIntoPrimitiveAlleles(VariantContext vc) {
        byte[] alt;
        Utils.nonNull(vc);
        if (!vc.isBiallelic()) {
            throw new IllegalArgumentException("Trying to break a multi-allelic Variant Context into primitive parts");
        }
        if (!vc.isMNP()) {
            return Arrays.asList(vc);
        }
        byte[] ref = vc.getReference().getBases();
        Utils.validate(ref.length == (alt = vc.getAlternateAllele(0).getBases()).length, "ref and alt alleles for MNP have different lengths");
        ArrayList<VariantContext> result = new ArrayList<VariantContext>(ref.length);
        for (int i = 0; i < ref.length; ++i) {
            if (ref[i] == alt[i]) continue;
            Allele newRefAllele = Allele.create((byte)ref[i], (boolean)true);
            Allele newAltAllele = Allele.create((byte)alt[i], (boolean)false);
            VariantContextBuilder newVC = new VariantContextBuilder(vc).start((long)(vc.getStart() + i)).stop((long)(vc.getStart() + i)).alleles(Arrays.asList(newRefAllele, newAltAllele));
            LinkedHashMap<Allele, Allele> alleleMap = new LinkedHashMap<Allele, Allele>();
            alleleMap.put(vc.getReference(), newRefAllele);
            alleleMap.put(vc.getAlternateAllele(0), newAltAllele);
            GenotypesContext newGenotypes = GATKVariantContextUtils.updateGenotypesWithMappedAlleles(vc.getGenotypes(), new AlleleMapper(alleleMap));
            result.add(newVC.genotypes(newGenotypes).make());
        }
        if (result.isEmpty()) {
            result.add(vc);
        }
        return result;
    }

    public static void addChromosomeCountsToHeader(Set<VCFHeaderLine> headerLines) {
        headerLines.add((VCFHeaderLine)VCFStandardHeaderLines.getInfoLine((String)"AC"));
        headerLines.add((VCFHeaderLine)VCFStandardHeaderLines.getInfoLine((String)"AN"));
        headerLines.add((VCFHeaderLine)VCFStandardHeaderLines.getInfoLine((String)"AF"));
    }

    public static void setFilteredGenotypeToNocall(VariantContextBuilder builder, VariantContext vc, boolean setFilteredGenotypesToNocall, BiFunction<VariantContext, Genotype, List<String>> filters) {
        Utils.nonNull(vc);
        Utils.nonNull(builder);
        Utils.nonNull(filters);
        GenotypesContext genotypes = GenotypesContext.create((int)vc.getGenotypes().size());
        boolean haveFilteredNoCallAlleles = false;
        for (Genotype g : vc.getGenotypes()) {
            if (g.isCalled()) {
                List<String> filterNames = filters.apply(vc, g);
                if (!filterNames.isEmpty() && setFilteredGenotypesToNocall) {
                    haveFilteredNoCallAlleles = true;
                    genotypes.add(new GenotypeBuilder(g).filters(filterNames).alleles(GATKVariantContextUtils.noCallAlleles(g.getPloidy())).make());
                    continue;
                }
                genotypes.add(new GenotypeBuilder(g).filters(filterNames).make());
                continue;
            }
            genotypes.add(g);
        }
        if (haveFilteredNoCallAlleles) {
            LinkedHashMap attributes = new LinkedHashMap(vc.getAttributes());
            VariantContextUtils.calculateChromosomeCounts((VariantContext)builder.genotypes(genotypes).make(), attributes, (boolean)true, (Set)vc.getSampleNames());
            builder.attributes(attributes);
        }
        builder.genotypes(genotypes);
    }

    public static int calculateGQFromPLs(int[] plValues) {
        Utils.nonNull(plValues);
        Utils.validateArg(plValues.length >= 2, () -> "Array of PL values must contain at least two elements.");
        int first = plValues[0];
        int second = plValues[1];
        if (first > second) {
            second = first;
            first = plValues[1];
        }
        for (int i = 2; i < plValues.length; ++i) {
            int candidate = plValues[i];
            if (candidate >= second) continue;
            if (candidate <= first) {
                second = first;
                first = candidate;
                continue;
            }
            second = candidate;
        }
        return second - first;
    }

    public static List<String> createFilterListWithAppend(VariantContext vc, String filterToAppend) {
        Utils.nonNull(vc);
        Utils.nonNull(filterToAppend);
        ArrayList<String> filtersAsList = new ArrayList<String>(vc.getFilters());
        filtersAsList.add(filterToAppend);
        filtersAsList.sort(String::compareToIgnoreCase);
        return filtersAsList;
    }

    public static boolean isFrameshift(Allele reference, Allele alternate) {
        Utils.nonNull(reference);
        Utils.nonNull(alternate);
        return Math.abs(reference.length() - alternate.length()) % 3 != 0;
    }

    public static boolean isFrameshift(String reference, String alternate) {
        Utils.nonNull(reference);
        Utils.nonNull(alternate);
        String refComparable = reference.replaceAll("\\*", "");
        String altComperable = alternate.replaceAll("\\*", "");
        return Math.abs(refComparable.length() - altComperable.length()) % 3 != 0;
    }

    public static boolean isFrameshift(int startPos, int refEnd, int altEnd) {
        ParamUtils.isPositive(startPos, "Genomic positions must be > 0.");
        ParamUtils.isPositive(refEnd, "Genomic positions must be > 0.");
        ParamUtils.isPositive(altEnd, "Genomic positions must be > 0.");
        int refLength = refEnd - startPos + 1;
        int altLength = altEnd - startPos + 1;
        return Math.abs(refLength - altLength) % 3 != 0;
    }

    public static boolean isInsertion(Allele reference, Allele alternate) {
        Utils.nonNull(reference);
        Utils.nonNull(alternate);
        return reference.length() < alternate.length();
    }

    public static boolean isInsertion(String reference, String alternate) {
        Utils.nonNull(reference);
        Utils.nonNull(alternate);
        String refComparable = reference.replaceAll("\\*", "");
        String altComperable = alternate.replaceAll("\\*", "");
        return refComparable.length() < altComperable.length();
    }

    public static boolean isDeletion(String reference, String alternate) {
        Utils.nonNull(reference);
        Utils.nonNull(alternate);
        String refComparable = reference.replaceAll("\\*", "");
        String altComperable = alternate.replaceAll("\\*", "");
        return refComparable.length() > altComperable.length();
    }

    public static boolean isDeletion(Allele reference, Allele alternate) {
        Utils.nonNull(reference);
        Utils.nonNull(alternate);
        return reference.length() > alternate.length();
    }

    public static boolean isIndel(String reference, String alternate) {
        Utils.nonNull(reference);
        Utils.nonNull(alternate);
        String refComparable = reference.replaceAll("\\*", "");
        String altComperable = alternate.replaceAll("\\*", "");
        return refComparable.length() != altComperable.length();
    }

    public static boolean isIndel(Allele reference, Allele alternate) {
        Utils.nonNull(reference);
        Utils.nonNull(alternate);
        return reference.length() != alternate.length();
    }

    public static boolean isXnp(Allele reference, Allele alternate) {
        Utils.nonNull(reference);
        Utils.nonNull(alternate);
        return reference.length() == alternate.length() && !reference.equals((Object)alternate);
    }

    public static boolean isXnp(String reference, String alternate) {
        Utils.nonNull(reference);
        Utils.nonNull(alternate);
        String refComparable = reference.replaceAll("\\*", "");
        String altComperable = alternate.replaceAll("\\*", "");
        return refComparable.length() == altComperable.length() && !refComparable.equals(altComperable);
    }

    public static boolean isSpanningDeletionOnly(VariantContext vc) {
        return vc.getAlternateAlleles().size() == 1 && GATKVCFConstants.isSpanningDeletion(vc.getAlternateAllele(0));
    }

    public static int[] matchAllelesOnly(VariantContext variant1, VariantContext variant2) {
        Utils.nonNull(variant1);
        Utils.nonNull(variant2);
        if (variant1.isBiallelic() && variant2.isBiallelic()) {
            if (variant1.getAlternateAllele(0).equals((Object)variant2.getAlternateAllele(0)) && variant1.getReference().equals((Object)variant2.getReference())) {
                return new int[]{0};
            }
            return new int[]{-1};
        }
        int[] result = new int[variant1.getAlternateAlleles().size()];
        List<VariantContext> splitVariants1 = GATKVariantContextUtils.simpleSplitIntoBiallelics(variant1);
        List<VariantContext> splitVariants2 = GATKVariantContextUtils.simpleSplitIntoBiallelics(variant2);
        for (int i = 0; i < splitVariants1.size(); ++i) {
            result[i] = -1;
            for (int j = 0; j < splitVariants2.size(); ++j) {
                VariantContext splitVariant1 = splitVariants1.get(i);
                VariantContext splitVariant2 = splitVariants2.get(j);
                if (!splitVariant1.getAlternateAllele(0).equals((Object)splitVariant2.getAlternateAllele(0)) || !splitVariant1.getReference().equals((Object)splitVariant2.getReference())) continue;
                result[i] = j;
            }
        }
        return result;
    }

    private static List<VariantContext> simpleSplitIntoBiallelics(VariantContext vc) {
        Utils.nonNull(vc);
        ArrayList<VariantContext> result = new ArrayList<VariantContext>();
        if (vc.isBiallelic()) {
            return Collections.singletonList(vc);
        }
        VariantContextBuilder vcb = new VariantContextBuilder("SimpleSplit", vc.getContig(), (long)vc.getStart(), (long)vc.getEnd(), Arrays.asList(vc.getReference(), Allele.NO_CALL));
        vc.getAlternateAlleles().forEach(allele -> result.add(GATKVariantContextUtils.trimAlleles(vcb.alleles(Arrays.asList(vc.getReference(), allele)).make(true), true, true)));
        return result;
    }

    public static boolean isUnmixedMnpIgnoringNonRef(VariantContext vc) {
        List alleles = vc.getAlleles();
        int length = vc.getReference().length();
        if (length < 2) {
            return false;
        }
        for (Allele a : alleles) {
            if (a.isSymbolic() && !Allele.NON_REF_ALLELE.equals((Object)a)) {
                return false;
            }
            if (a.isSymbolic() || a.length() == length) continue;
            return false;
        }
        return true;
    }

    public static <T> List<T> removeDataForSymbolicAltAlleles(VariantContext vc, List<T> data) {
        return GATKVariantContextUtils.removeDataForSymbolicAlleles(vc, data, false);
    }

    public static <T> List<T> removeDataForSymbolicAlleles(VariantContext vc, List<T> data) {
        return GATKVariantContextUtils.removeDataForSymbolicAlleles(vc, data, true);
    }

    protected static <T> List<T> removeDataForSymbolicAlleles(VariantContext vc, List<T> data, boolean dataContainsReference) {
        if (vc.hasSymbolicAlleles()) {
            List symbolicAlleles = vc.getAlternateAlleles().stream().filter(allele -> allele.isSymbolic()).collect(Collectors.toList());
            int offset = dataContainsReference ? 0 : 1;
            List<Integer> symAltIndexes = vc.getAlleleIndices(symbolicAlleles).stream().map(i -> i - offset).collect(Collectors.toList());
            return GATKVariantContextUtils.removeItemsByIndex(data, symAltIndexes);
        }
        return data;
    }

    public static <T> List<T> removeItemsByIndex(List<T> data, List<Integer> indexesToRemove) {
        ArrayList updated = new ArrayList();
        new IndexRange(0, data.size()).forEach(i -> {
            if (!indexesToRemove.contains(i)) {
                updated.add(data.get(i));
            }
        });
        return updated;
    }

    private static class CompareByPriority
    implements Comparator<VariantContext>,
    Serializable {
        private static final long serialVersionUID = 0L;
        List<String> priorityListOfVCs;

        public CompareByPriority(List<String> priorityListOfVCs) {
            this.priorityListOfVCs = priorityListOfVCs;
        }

        private int getIndex(VariantContext vc) {
            return Utils.validIndex(this.priorityListOfVCs.indexOf(vc.getSource()), this.priorityListOfVCs.size());
        }

        @Override
        public int compare(VariantContext vc1, VariantContext vc2) {
            return Integer.valueOf(this.getIndex(vc1)).compareTo(this.getIndex(vc2));
        }
    }

    protected static class AlleleMapper {
        private VariantContext vc = null;
        private Map<Allele, Allele> map = null;

        public AlleleMapper(VariantContext vc) {
            this.vc = vc;
        }

        public AlleleMapper(Map<Allele, Allele> map) {
            this.map = map;
        }

        public boolean needsRemapping() {
            return this.map != null;
        }

        public Collection<Allele> values() {
            return this.map != null ? this.map.values() : this.vc.getAlleles();
        }

        public Allele remap(Allele a) {
            return this.map != null && this.map.containsKey(a) ? this.map.get(a) : a;
        }

        public List<Allele> remap(List<Allele> as) {
            List<Allele> newAs = as.stream().map(this::remap).collect(Collectors.toList());
            return newAs;
        }
    }

    public static enum FilteredRecordMergeType {
        KEEP_IF_ANY_UNFILTERED,
        KEEP_IF_ALL_UNFILTERED,
        KEEP_UNCONDITIONAL;

    }

    public static enum GenotypeMergeType {
        UNIQUIFY,
        PRIORITIZE,
        UNSORTED,
        REQUIRE_UNIQUE;

    }
}

