/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.variant;

import java.io.Serializable;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.variant.GATKVariant;

public class MinimalVariant
implements GATKVariant,
Serializable {
    private static final long serialVersionUID = 1L;
    private final SimpleInterval interval;
    private final boolean snp;
    private final boolean indel;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MinimalVariant that = (MinimalVariant)o;
        if (this.isSnp() != that.isSnp()) {
            return false;
        }
        if (this.isIndel() != that.isIndel()) {
            return false;
        }
        return !(this.interval == null ? that.interval != null : !this.interval.equals(that.interval));
    }

    public int hashCode() {
        int result = this.interval != null ? this.interval.hashCode() : 0;
        result = 31 * result + (this.isSnp() ? 1 : 0);
        result = 31 * result + (this.isIndel() ? 1 : 0);
        return result;
    }

    public MinimalVariant(SimpleInterval interval, boolean isSNP, boolean isIndel) {
        this.interval = interval;
        this.snp = isSNP;
        this.indel = isIndel;
    }

    public String getContig() {
        return this.interval.getContig();
    }

    public int getStart() {
        return this.interval.getStart();
    }

    public int getEnd() {
        return this.interval.getEnd();
    }

    @Override
    public boolean isSnp() {
        return this.snp;
    }

    @Override
    public boolean isIndel() {
        return this.indel;
    }

    public String toString() {
        return String.format("MinimalVariant -- interval(%s:%d-%d), snp(%b), indel(%b)", this.interval.getContig(), this.interval.getStart(), this.interval.getEnd(), this.snp, this.indel);
    }
}

