/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.variant;

import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.broadinstitute.hellbender.exceptions.GATKException;
import org.broadinstitute.hellbender.utils.Utils;

public class VariantContextGetters {
    public static int getAttributeAsInt(Genotype genotype, String key, int defaultValue) {
        Utils.nonNull(genotype);
        Utils.nonNull(key);
        Object value = genotype.getExtendedAttribute(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(String.valueOf(value));
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException(String.format("attribute '%s' does not have a valid integer value: '%s'", key, String.valueOf(value)));
        }
    }

    public static int[] getAttributeAsIntArray(VariantContext variantContext, String key, Supplier<int[]> defaultValue, int missingValue) {
        Utils.nonNull(variantContext);
        return VariantContextGetters.attributeValueToIntArray(variantContext.getAttribute(key), key, defaultValue, missingValue);
    }

    public static int[] getAttributeAsIntArray(Genotype genotype, String key, Supplier<int[]> defaultValue, int missingValue) {
        Utils.nonNull(genotype);
        return VariantContextGetters.attributeValueToIntArray(genotype.getExtendedAttribute(key), key, defaultValue, missingValue);
    }

    public static double getAttributeAsDouble(Genotype genotype, String key, double defaultValue) {
        Utils.nonNull(genotype);
        Utils.nonNull(key);
        Object value = genotype.getExtendedAttribute(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(String.valueOf(value));
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException(String.format("attribute '%s' does not have a valid double value: '%s'", key, String.valueOf(value)));
        }
    }

    public static double[] getAttributeAsDoubleArray(VariantContext variantContext, String key, Supplier<double[]> defaultValue, double missingValue) {
        Utils.nonNull(variantContext);
        return VariantContextGetters.attributeValueToDoubleArray(variantContext.getAttribute(key), key, defaultValue, missingValue);
    }

    public static double[] getAttributeAsDoubleArray(VariantContext variantContext, String attribute) {
        return VariantContextGetters.getAttributeAsDoubleArray(variantContext, attribute, () -> null, -1.0);
    }

    public static double[] getAttributeAsDoubleArray(Genotype genotype, String key, Supplier<double[]> defaultValue, double missingValue) {
        Utils.nonNull(genotype);
        return VariantContextGetters.attributeValueToDoubleArray(genotype.getExtendedAttribute(key), key, defaultValue, missingValue);
    }

    public static Long getAttributeAsLong(VariantContext variantContext, String attribute, Long defaultValue) {
        Utils.nonNull(variantContext);
        Utils.nonNull(attribute);
        Object x = variantContext.getAttribute(attribute);
        if (x == null || x.equals(".")) {
            return defaultValue;
        }
        if (x instanceof Number) {
            return ((Number)x).longValue();
        }
        return Long.valueOf((String)x);
    }

    public static List<Long> getAttributeAsLongList(VariantContext variantContext, String attribute, Long defaultValue) {
        Utils.nonNull(variantContext);
        Utils.nonNull(attribute);
        return variantContext.getAttributeAsList(attribute).stream().map(x -> {
            if (x == null || x.equals(".")) {
                return defaultValue;
            }
            if (x instanceof Number) {
                return ((Number)x).longValue();
            }
            return Long.valueOf((String)x);
        }).collect(Collectors.toList());
    }

    public static String getAttributeAsString(Genotype genotype, String key, String defaultValue) {
        Utils.nonNull(genotype);
        Utils.nonNull(key);
        Object value = genotype.getExtendedAttribute(key);
        if (value == null) {
            return defaultValue;
        }
        return String.valueOf(value);
    }

    public static List<Object> attributeToList(Object attribute) {
        if (attribute == null) {
            return Collections.emptyList();
        }
        if (attribute instanceof List) {
            return (List)attribute;
        }
        if (attribute.getClass().isArray()) {
            if (attribute instanceof int[]) {
                return Arrays.stream((int[])attribute).boxed().collect(Collectors.toList());
            }
            if (attribute instanceof double[]) {
                return Arrays.stream((double[])attribute).boxed().collect(Collectors.toList());
            }
            return Arrays.asList((Object[])attribute);
        }
        if (attribute instanceof String) {
            return new ArrayList<Object>(Arrays.asList((Object[])((String)attribute).split(",")));
        }
        return Collections.singletonList(attribute);
    }

    private static int[] attributeValueToIntArray(Object value, String key, Supplier<int[]> defaultResult, int missingValue) {
        Utils.nonNull(key);
        ToIntFunction<Object> intConverter = o -> {
            if (o == null) {
                return missingValue;
            }
            String s = String.valueOf(o).trim();
            if (s.equals(".")) {
                return missingValue;
            }
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                throw new GATKException(String.format("INFO annotation '%s' contains a non-int value '%s'", key, s), ex);
            }
        };
        if (value == null) {
            return defaultResult.get();
        }
        if (value.getClass().isArray()) {
            int[] result = new int[Array.getLength(value)];
            for (int i = 0; i < result.length; ++i) {
                result[i] = intConverter.applyAsInt(String.valueOf(Array.get(value, i)));
            }
            return result;
        }
        if (value.getClass().isAssignableFrom(Iterable.class)) {
            return StreamSupport.stream(((Iterable)value).spliterator(), false).mapToInt(intConverter).toArray();
        }
        return Stream.of(String.valueOf(value).trim().replaceAll("\\[|\\]", "").split(",")).mapToInt(intConverter).toArray();
    }

    private static double[] attributeValueToDoubleArray(Object value, String key, Supplier<double[]> defaultResult, double missingValue) {
        Utils.nonNull(key);
        ToDoubleFunction<Object> doubleConverter = o -> {
            if (o == null) {
                return missingValue;
            }
            String s = String.valueOf(o);
            if (s.equals(".")) {
                return missingValue;
            }
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException ex) {
                throw new GATKException(String.format("INFO annotation '%s' contains a non-double value '%s'", key, s), ex);
            }
        };
        if (value == null) {
            return defaultResult.get();
        }
        if (value.getClass().isArray()) {
            double[] result = new double[Array.getLength(value)];
            for (int i = 0; i < result.length; ++i) {
                result[i] = doubleConverter.applyAsDouble(String.valueOf(Array.get(value, i)));
            }
            return result;
        }
        if (value.getClass().isAssignableFrom(Iterable.class)) {
            return StreamSupport.stream(((Iterable)value).spliterator(), false).mapToDouble(doubleConverter).toArray();
        }
        return Stream.of(String.valueOf(value).trim().replaceAll("\\[|\\]", "").split(",")).mapToDouble(doubleConverter).toArray();
    }
}

