/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.variant;

import htsjdk.variant.variantcontext.VariantContext;
import java.io.Serializable;
import org.broadinstitute.hellbender.utils.SimpleInterval;
import org.broadinstitute.hellbender.utils.variant.GATKVariant;
import org.broadinstitute.hellbender.utils.variant.MinimalVariant;

public class VariantContextVariantAdapter
implements GATKVariant,
Serializable {
    private static final long serialVersionUID = 1L;
    private final VariantContext variantContext;

    public VariantContextVariantAdapter(VariantContext vc) {
        this.variantContext = vc;
    }

    public static GATKVariant sparkVariantAdapter(VariantContext vc) {
        return new MinimalVariant(new SimpleInterval(vc.getContig(), vc.getStart(), vc.getEnd()), vc.isSNP(), vc.isIndel());
    }

    public String getContig() {
        return this.variantContext.getContig();
    }

    public int getStart() {
        return this.variantContext.getStart();
    }

    public int getEnd() {
        return this.variantContext.getEnd();
    }

    @Override
    public boolean isSnp() {
        return this.variantContext.isSNP();
    }

    @Override
    public boolean isIndel() {
        return this.variantContext.isIndel();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariantContextVariantAdapter that = (VariantContextVariantAdapter)o;
        if (!this.getContig().equals(that.getContig())) {
            return false;
        }
        if (this.getStart() != that.getStart()) {
            return false;
        }
        if (this.getEnd() != that.getEnd()) {
            return false;
        }
        if (this.isSnp() != that.isSnp()) {
            return false;
        }
        return this.isIndel() != that.isIndel();
    }

    public int hashCode() {
        return this.variantContext.hashCode();
    }

    public String toString() {
        return String.format("VariantContextVariantAdapter -- interval(%s:%d-%d), snp(%b), indel(%b)", this.getContig(), this.getStart(), this.getEnd(), this.isSnp(), this.isIndel());
    }
}

