/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.hellbender.utils.variant;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.broadinstitute.hellbender.utils.variant.GATKVCFIndexType;
import org.broadinstitute.hellbender.utils.variant.GATKVariantContextUtils;

public final class VcfUtils {
    public static final String VCF_FILE_EXTENSION = "vcf";
    public static final String BCF_FILE_EXTENSION = "bcf";
    public static final GATKVCFIndexType DEFAULT_GVCF_INDEX_TYPE = GATKVCFIndexType.LINEAR;
    public static final Integer DEFAULT_GVCF_INDEX_PARAMETER = 128000;

    private VcfUtils() {
    }

    public static SortedSet<String> getSortedSampleSet(Map<String, VCFHeader> headers, GATKVariantContextUtils.GenotypeMergeType mergeOption) {
        TreeSet<String> samples = new TreeSet<String>();
        for (Map.Entry<String, VCFHeader> val : headers.entrySet()) {
            VCFHeader header = val.getValue();
            samples.addAll(header.getGenotypeSamples().stream().map(sample -> GATKVariantContextUtils.mergedSampleName((String)val.getKey(), sample, mergeOption == GATKVariantContextUtils.GenotypeMergeType.UNIQUIFY)).collect(Collectors.toList()));
        }
        return samples;
    }

    public static boolean usingGVCFIndexingArguments(GATKVCFIndexType variantIndexType, int variantIndexParameter) {
        return variantIndexType == DEFAULT_GVCF_INDEX_TYPE && variantIndexParameter == DEFAULT_GVCF_INDEX_PARAMETER;
    }

    public static Set<VCFHeaderLine> updateHeaderContigLines(Set<VCFHeaderLine> oldLines, Path referencePath, SAMSequenceDictionary refDict, boolean referenceNameOnly) {
        LinkedHashSet<VCFHeaderLine> lines = new LinkedHashSet<VCFHeaderLine>(oldLines.size());
        for (VCFHeaderLine line : oldLines) {
            if (line instanceof VCFContigHeaderLine || line.getKey().equals("reference")) continue;
            lines.add(line);
        }
        lines.addAll(VcfUtils.makeContigHeaderLines(refDict, referencePath).stream().collect(Collectors.toList()));
        if (referencePath != null) {
            int extensionStart;
            String referenceValue = referenceNameOnly ? ((extensionStart = referencePath.getFileName().toString().lastIndexOf(".")) == -1 ? referencePath.getFileName().toString() : referencePath.getFileName().toString().substring(0, extensionStart)) : referencePath.toUri().toString();
            lines.add(new VCFHeaderLine("reference", referenceValue));
        }
        return lines;
    }

    private static List<VCFContigHeaderLine> makeContigHeaderLines(SAMSequenceDictionary refDict, Path referencePath) {
        ArrayList<VCFContigHeaderLine> lines = new ArrayList<VCFContigHeaderLine>();
        String assembly = referencePath != null ? referencePath.getFileName().toString() : null;
        lines.addAll(refDict.getSequences().stream().map(contig -> VcfUtils.makeContigHeaderLine(contig, assembly)).collect(Collectors.toList()));
        return lines;
    }

    private static VCFContigHeaderLine makeContigHeaderLine(SAMSequenceRecord contig, String assembly) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(3);
        map.put("ID", contig.getSequenceName());
        map.put("length", String.valueOf(contig.getSequenceLength()));
        if (assembly != null) {
            map.put("assembly", assembly);
        }
        return new VCFContigHeaderLine(map, contig.getSequenceIndex());
    }
}

